/** CaseEvent.java in the package org.JIFSA.tools of the JIFSA project.
    Originally created 16-Oct-2008

    Copyright (C) 2008  Edgar Acosta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.tools;

import java.util.ArrayList;
import java.util.EventObject;
import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;

/** Class definition of Case Events.
 *
 * This class defines CaseEvent objects. These events occur when
 * another class creates Cases and Case Bases.
 *
 * @author Edgar Acosta
 * @since 0.5
 *
 */
public class CaseEvent extends EventObject
{
    private AgentInputs aInputs;
    private ArrayList<AgentAction> aActions;
    private String m_teamName;

    /** CaseEvent constructor
     *
     * This constructor initializes a dummy event.
     *
     * @param source the object producing the Event
     *
     * @author Edgar Acosta
     *
     */
    public CaseEvent(Object source)
    {
	super(source);
    }

    /** CaseEvent constructor
     *
     * This constructor initializes the event with only the Inputs of
     * the Case. It is called when all the inputs have been processed.
     *
     * @param source the object producing the Event
     * @param ai the agent inputs (an AgentInputs object)
     *
     * @author Edgar Acosta
     *
     */
    public CaseEvent(Object source,AgentInputs ai)
    {
	super(source);
	aInputs=ai;
	aActions=new ArrayList<AgentAction>();
    }

    /** CaseEvent constructor
     *
     * This constructor initializes the event with only the Outputs of
     * the Case. It is called when all the outputs have been
     * processed.
     *
     * @param source the object producing the Event
     * @param aa the agent outputs
     *
     * @author Edgar Acosta
     *
     */
    public CaseEvent(Object source,ArrayList<AgentAction> aa)
    {
	super(source);
	aActions=aa;
	aInputs= new AgentInputs();
    }

    /** CaseEvent constructor
     *
     * This constructor initializes the event with only the team name.
     * It is called when the team name has been captured
     *
     * @param source the object producing the Event
     * @param aa the agent outputs
     *
     * @author Edgar Acosta
     *
     */
    public CaseEvent(Object source,String teamName)
    {
	super(source);
	m_teamName=teamName;
    }

    /** Agent Inputs getter
     *
     * @return the Agent Inputs
     *
     * @author Edgar Acosta
     *
     */
    public AgentInputs getAgentInputs(){
	return aInputs;
    }

    /** Agent Outputs getter
     *
     * @return the Agent Outputs
     *
     * @author Edgar Acosta
     *
     */
    public ArrayList<AgentAction> getAgentActions(){
	return aActions;
    }

    /** Team Name getter
     *
     * @return the Agent Team Name
     *
     * @author Edgar Acosta
     *
     */
    public String getTeamName(){
	return m_teamName;
    }
}
