/** CaseEventListener.java in the package org.JIFSA.tools of the JIFSA project.
    Originally created 16-Oct-2008

    Copyright (C) 2008  Edgar Acosta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.tools;

/**
 * Interface for CaseEventListener.
 *
 * This interface is for listeners of Case Events
 *
 * @author Edgar Acosta
 * @since 0.4
 *
 */
public interface CaseEventListener {

    /** Actions retrieved
     *
     * This method is called when all the actions that conform the
     * Case output have been obtained.
     *
     * @param ce the Case Event contains the output Actions.
     *
     * @author Edgar Acosta
     *
     */
    public void GotActions(CaseEvent ce);

    /** AgentInputs retrieved
     *
     * This method is called when all the agent inputs that conform the
     * Case input have been obtained.
     *
     * @param ce the Case Event contains the inputs.
     *
     * @author Edgar Acosta
     *
     */
    public void GotInputs(CaseEvent ce);

    /** Signals TimeOver
     *
     * This method is called when the referee calls for the end of the game.
     *
     * @param ce the Case Event contains the inputs.
     *
     * @author Edgar Acosta
     *
     */
    public void TimeOver(CaseEvent ce);

    /** Occurs when the client initiates a connection
     *
     * This method is called when the agent sends an InitMessage. It
     * is used to fetch the team name when parsing a LogFile
     *
     * @param ce the Case Event contains the inputs.
     *
     * @author Edgar Acosta
     *
     */
    public void Connecting(CaseEvent ce);

    /** Occurs when the server accepts a connection
     *
     * This method is called when the server acknowledges an InitMessage. It
     * is used to start the Brain of the agent.
     *
     * @param ce the Case Event contains the inputs.
     *
     * @author Edgar Acosta
     *
     */
    public void Connected(CaseEvent ce);

    /** Occurs when a team name has not been provided nor discovered.
     *
     * @param ce the Case Event contains the inputs.
     *
     * @author Edgar Acosta
     *
     */
    public void TeamNameMissing(CaseEvent ce);
}
