/** AgentActionTest.java in the package tests.junit.org.JIFSA of the JIFSA project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.JIFSA;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.JIFSA.AgentAction;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/** Tests for org.JIFSA.AgentAction class
 * 
 * @author Michael W. Floyd
 * @since 0.1
 */
public class AgentActionTest {

	/** Test to make sure the default constructor
	 * creates a default action name
	 * 
	 * @author Michael W. Floyd
	 * @since 0.1
	 */
	@Test
	public void defaultConstructor(){
		AgentAction action = new AgentAction();
		String name = action.getActionName();
		assertTrue(name.equals(AgentAction.c_DEFAULT));
	}
	
	/** Test to make sure the constructor
	 * creates an action name based on a parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.1
	 */
	@Test 
	public void stringConstructor(){
		AgentAction action = new AgentAction("myAction");
		String name = action.getActionName();
		assertTrue(name.equals("myAction"));
	}
	
	/** Tests to make sure the constructor acts
	 * as expected when given null parameters
	 * 
	 * @author Michael W. Floyd
	 * @since 0.1
	 */
	@Test(expected=IllegalArgumentException.class) 
	public void stringConstructor_nullparam(){
		new AgentAction(null);
	}
	
	/** Test to see if an AgentAction if found
	 * to be equal to a null value
	 * 
	 * @author Michael W. Floyd
	 * @since 0.1
	 */
	@Test
	public void equals_null(){
		AgentAction a = new AgentAction();
		assertFalse(a.equals(null));
	}
	
	/** Test to see if an AgentAction is found to
	 * be equal to an object of a different class
	 * 
	 * @author Michael W. Floyd
	 * @since 0.1
	 */
	@Test 
	public void equals_differntClass(){
		AgentAction a  = new AgentAction();
		String s = "String";
		assertFalse(a.equals(s));
	}
	
	/** Test to see if two AgentActions of the same
	 * type are found to be equal.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.1
	 */
	@Test
	public void equals_equal(){
		AgentAction a1 = new AgentAction("myAction");
		AgentAction a2 = new AgentAction("myAction");
		assertEquals(a1,a2);
	}
	
	/** Test to see if two AgentActions of a different
	 * type are found to be equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.1
	 */
	@Test
	public void equals_unequal(){
		AgentAction a1 = new AgentAction("myAction");
		AgentAction a2 = new AgentAction("otherAction");
		assertFalse(a1.equals(a2));
	}
	
	/** Tests to make sure that an item is equal to itself
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_self(){
		AgentAction a1 = new AgentAction("myAction");
		assertTrue(a1.equals(a1));
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(AgentActionTest.class);
	}
}
