/** CaseActionPairTest.java in the package tests.junit.org.JIFSA.performance.datatypes of the JIFSA project.
    Originally created 09-Aug-08

    Copyright (C) 2008 Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.JIFSA.performance.datatypes;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;

import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;
import org.JIFSA.performance.datatypes.CaseActionPair;
import org.junit.Test;

/** Tests for the org.JIFSA.performance.datatypes.CaseActionPair class
 * 
 * @author Michael W. Floyd
 * @since 0.4
 */
public class CaseActionPairTest {

	/** Tests the constructor with a null Case
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test(expected=IllegalArgumentException.class)
	public void constructor_nullCase(){
		AgentAction act = new AgentAction();
		new CaseActionPair(null,act);
	}
	
	/** Tests the constructor with a null AgentAction
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test(expected=IllegalArgumentException.class)
	public void constructor_nullAgentAction(){
		Case c = new Case();
		new CaseActionPair(c,null);
	}
	
	/** Tests the constructor and makes sure the Case
	 * is properly set
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test
	public void constructor_validCase(){
		AgentAction aa = new AgentAction("firstAction");
		AgentInputs ai = new AgentInputs();
		ArrayList<AgentAction> al = new ArrayList<AgentAction>();
		al.add(aa);
		Case c = new Case(ai,al);
		AgentAction act = new AgentAction("someAction");
		
		CaseActionPair cap = new CaseActionPair(c,act);
		Case returned = cap.getCase();
		
		assertEquals(c,returned);
	}
	
	/** Tests the constructor and makes sure the AgentAction
	 * is properly set
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test
	public void constructor_validAgentAction(){
		AgentAction aa = new AgentAction("firstAction");
		AgentInputs ai = new AgentInputs();
		ArrayList<AgentAction> al = new ArrayList<AgentAction>();
		al.add(aa);
		Case c = new Case(ai,al);
		AgentAction act = new AgentAction("someAction");
		
		CaseActionPair cap = new CaseActionPair(c,act);
		AgentAction returned = cap.getAction();
		
		assertEquals(act,returned);
	}
}
