/** ClusterTest.java in the package tests.junit.org.JIFSA.preprocessing.cluster of the JIFSA project.
    Originally created 02-Oct-08

    Copyright (C) 2008 Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.JIFSA.preprocessing.cluster;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;
import org.JIFSA.preprocessing.cluster.Cluster;
import org.junit.Test;

/** Tests for the org.JIFSA.preprocessing.cluster.Cluster class.
 * 
 * @author Michael W. Floyd
 * @since 0.5
 *
 */
public class ClusterTest {

	/** Tests the constructor to see that default values
	 * are properly set
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test
	public void constructor_defaults(){
		Cluster c = new Cluster();
		
		List<Case> members = c.getMembers();
		assertNotNull(members);
		assertEquals(members.size(), 0);
	}
	
	/** Tests adding a null value to the Cluster
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test(expected=IllegalArgumentException.class)
	public void addMember_null(){
		Cluster c = new Cluster();
		
		c.addMember(null);
	}
	
	/** Tests adding and getting valid values
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test
	public void getMembers_valid(){
		Cluster c = new Cluster();
		List<Case> added = new ArrayList<Case>();
		
		for(int ii=0; ii< 100; ii++){
			AgentInputs ai = new AgentInputs();
			List<AgentAction> al = new ArrayList<AgentAction>();
			al.add(new AgentAction("act" + ii));
			Case newcase = new Case(ai,al);
			c.addMember(newcase);
			added.add(newcase);
		}
		
		List<Case> memb = c.getMembers();
		assertNotNull(memb);
		assertEquals(memb.size(), 100);
		
		for(int ii=0;ii<100;ii++){
			assertTrue(memb.contains(added.get(ii)));
		}
			
	}
	
	
	
}
