/** LastActionEstimationTest.java in the package tests.junit.org.JIFSA.reasoning.actionselection.actionestimation of the JIFSA project.
    Originally created 23-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.JIFSA.reasoning.actionselection.actionestimation;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import org.JIFSA.AgentAction;
import org.JIFSA.reasoning.actionselection.actionestimation.LastActionEstimate;
import org.junit.Test;

/** Tests for the org.JIFSA.reasoning.actionselection.actionestimation.LastActionEstimation class
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public class LastActionEstimationTest {

	/** Tests the function given a null parameter.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test(expected=IllegalArgumentException.class)
	public void estimateAction_null(){
		LastActionEstimate lae = new LastActionEstimate();
		lae.estimateAction(null);
	}
	
	/** Tests the function given an empty list.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test
	public void estimateAction_empty(){
		LastActionEstimate lae = new LastActionEstimate();
		List<AgentAction> actions = new ArrayList<AgentAction>();
		assertNull(lae.estimateAction(actions));
	}
	
	/** Tests the function given a list
	 * consisting of one item.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test
	public void estimateAction_single(){
		LastActionEstimate lae = new LastActionEstimate();
		List<AgentAction> actions = new ArrayList<AgentAction>();
		AgentAction a1 = new AgentAction("someAction");
		actions.add(a1);
		AgentAction estimated = lae.estimateAction(actions);
		assertEquals(a1,estimated);
	}
	
	/** Tests the function given a list of
	 * multiple items.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test
	public void estimateAction_multiple(){
		LastActionEstimate lae = new LastActionEstimate();
		List<AgentAction> actions = new ArrayList<AgentAction>();
		AgentAction a1 = new AgentAction("someAction");
		actions.add(a1);
		AgentAction a2 = new AgentAction("secondAction");
		actions.add(a2);
		AgentAction a3 = new AgentAction("thirdAction");
		actions.add(a3);
		AgentAction a4 = new AgentAction("lastAction");
		actions.add(a4);
		AgentAction estimated = lae.estimateAction(actions);
		assertEquals(a4,estimated);
	}
}
