/** GlobalDistanceMeasureTest.java in the package tests.junit.org.JIFSA.reasoning.distance of the JIFSA project.
    Originally created Nov 23, 2007

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.JIFSA.reasoning.distance;

import static org.junit.Assert.assertEquals;

import org.JIFSA.Case;
import org.JIFSA.reasoning.Weights;
import org.JIFSA.reasoning.distance.GlobalDistanceMeasure;
import org.junit.Test;

/** Tests for the org.JIFSA.reasoning.distance.GlobalDistanceMeasure class
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public class GlobalDistanceMeasureTest {

	/** Tests the constructor with a null parameter.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test(expected=IllegalArgumentException.class)
	public void constructor_nullWeight(){
		new GlobalDistanceMeasure(null){

			@Override
			public float pairwiseDistance(Case c1, Case c2) {
				//this method is only here so we can create the abstract class
				return 0;
			}
			
		};
	}
	
	/** Tests the constructor with a valid parameter.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test
	public void constructor_valid(){
		Weights w = new Weights(1.0f);
		GlobalDistanceMeasure gdm = new GlobalDistanceMeasure(w){

			@Override
			public float pairwiseDistance(Case c1, Case c2) {
				//this method is only here so we can create the abstract class
				return 0;
			}
			
		};
		assertEquals(w, gdm.getWeights());
	}
	
	/** Tests the method with a null parameter.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test(expected=IllegalArgumentException.class)
	public void setWeights_nullWeights(){
		Weights w = new Weights(1.0f);
		GlobalDistanceMeasure gdm = new GlobalDistanceMeasure(w){

			@Override
			public float pairwiseDistance(Case c1, Case c2) {
				//this method is only here so we can create the abstract class
				return 0;
			}
			
		};
		gdm.setWeights(null);
	}
	
	/** Tests the method with a valid parameter.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test
	public void constructor_nullLocal(){
		Weights w = new Weights(1.0f);
		GlobalDistanceMeasure gdm = new GlobalDistanceMeasure(w){

			@Override
			public float pairwiseDistance(Case c1, Case c2) {
				//this method is only here so we can create the abstract class
				return 0;
			}
			
		};
		Weights w2 = new Weights(0.5f);
		gdm.setWeights(w2);
		assertEquals(w2, gdm.getWeights());
	}
	
	
}
