/** ConstantPenaltyTest.java in the package tests.junit.org.JIFSA.reasoning.distance.penalty of the JIFSA project.
    Originally created 16-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.JIFSA.reasoning.distance.penalty;

import static org.junit.Assert.assertEquals;

import java.util.Random;

import org.JIFSA.SensoryItem;
import org.JIFSA.reasoning.distance.penalty.ConstantPenalty;
import org.junit.Test;

/** Tests for the org.JIFSA.reasoning.distance.penalty.ConstantPenalty class
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public class ConstantPenaltyTest {

	/** Test to make sure the supplied penalty
	 * is actually the penalty that is returned
	 * by the calculatePenalty function.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test 
	public void constructor_varietyOfValues(){
		Random rand = new Random();
		SensoryItem f = new SensoryItem("someFeature");
		
		for(int ii=0;ii<1000;ii++){
			float val = rand.nextFloat();
			val = val * 100;
			ConstantPenalty cp = new ConstantPenalty(val);
			assertEquals(cp.calculatePenalty(f),val);
			cp = new ConstantPenalty(-val);
			assertEquals(cp.calculatePenalty(f),-val);
		}
	}
	
	/** Tests giving the function a null parameter.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	@Test(expected=IllegalArgumentException.class)
	public void calculatePentalty_null(){
		ConstantPenalty cp = new ConstantPenalty(14f);
		cp.calculatePenalty(null);
	}
	
}
