/** CaseBaseMergerTest.java in the package tests.junit.org.JIFSA.tools of the JIFSA project.
    Originally created 30-Sep-08

    Copyright (C) 2008 Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.JIFSA.tools;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.tools.CaseBaseMerger;
import org.junit.Before;
import org.junit.Test;

/** Unit tests for the org.JIFSA.tools.CaseBaseMerger class
 * 
 * @author Michael W. Floyd
 * @since 0.4
 */
public class CaseBaseMergerTest {

	private CaseBase cb1;
	private CaseBase cb3;
	private CaseBase cb5;
	
	/** Create the CaseBases that will be merged later
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Before
	public void setup_createCBs(){
		AgentInputs ai1 = new AgentInputs();
		List<AgentAction> al1 = new ArrayList<AgentAction>();
		al1.add(new AgentAction("firstAction"));
		Case c1 = new Case(ai1,al1);
		
		AgentInputs ai2 = new AgentInputs();
		List<AgentAction> al2 = new ArrayList<AgentAction>();
		al2.add(new AgentAction("secondAction"));
		Case c2 = new Case(ai2,al2);
		
		AgentInputs ai3 = new AgentInputs();
		List<AgentAction> al3 = new ArrayList<AgentAction>();
		al3.add(new AgentAction("thirdAction"));
		Case c3 = new Case(ai3,al3);
		
		AgentInputs ai4 = new AgentInputs();
		List<AgentAction> al4 = new ArrayList<AgentAction>();
		al4.add(new AgentAction("fourthAction"));
		Case c4 = new Case(ai4,al4);
		
		AgentInputs ai5 = new AgentInputs();
		List<AgentAction> al5 = new ArrayList<AgentAction>();
		al5.add(new AgentAction("fifthAction"));
		Case c5 = new Case(ai5,al5);
		
		AgentInputs ai6 = new AgentInputs();
		List<AgentAction> al6 = new ArrayList<AgentAction>();
		al6.add(new AgentAction("sixthAction"));
		Case c6 = new Case(ai6,al6);
		
		AgentInputs ai7 = new AgentInputs();
		List<AgentAction> al7 = new ArrayList<AgentAction>();
		al7.add(new AgentAction("seventhAction"));
		Case c7 = new Case(ai7,al7);
		
		AgentInputs ai8 = new AgentInputs();
		List<AgentAction> al8 = new ArrayList<AgentAction>();
		al8.add(new AgentAction("eighthAction"));
		Case c8 = new Case(ai8,al8);
		
		AgentInputs ai9 = new AgentInputs();
		List<AgentAction> al9 = new ArrayList<AgentAction>();
		al9.add(new AgentAction("ninthAction"));
		Case c9 = new Case(ai9,al9);
		
		this.cb1 = new CaseBase();
		this.cb1.addCase(c1);
		
		this.cb3 = new CaseBase();
		this.cb3.addCase(c2);
		this.cb3.addCase(c3);
		this.cb3.addCase(c4);
		
		this.cb5 = new CaseBase();
		this.cb5.addCase(c5);
		this.cb5.addCase(c6);
		this.cb5.addCase(c7);
		this.cb5.addCase(c8);
		this.cb5.addCase(c9);
	}
	
	/** Test with a null parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test(expected=IllegalArgumentException.class)
	public void merge_null(){
		CaseBaseMerger.merge(null);
	}
	
	/** Test when only no casebases are supplied
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test
	public void merge_none(){
		//test making sure creating the object doesn't cause a problem,
		//even though we use it in a static context
		new CaseBaseMerger();
		
		//now we do the actual test
		Collection<CaseBase> bases = new ArrayList<CaseBase>();
		
		CaseBase merged = CaseBaseMerger.merge(bases);
		
		assertNotNull(merged);
		assertEquals(merged.getCasebaseSize(), 0);
	}
	
	/** Test when only one casebase is supplied
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test
	public void merge_onlyOne(){
		Collection<CaseBase> bases = new ArrayList<CaseBase>();
		
		bases.add(this.cb3);
		
		CaseBase merged = CaseBaseMerger.merge(bases);
		
		assertNotNull(merged);
		assertEquals(merged.getCasebaseSize(), 3);
	}
	
	/** Test when only multiple casebases are supplied
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test
	public void merge_multiple(){
		Collection<CaseBase> bases = new ArrayList<CaseBase>();
		
		bases.add(this.cb1);
		bases.add(this.cb3);
		bases.add(this.cb5);
		
		CaseBase merged = CaseBaseMerger.merge(bases);
		
		assertNotNull(merged);
		assertEquals(merged.getCasebaseSize(), 9);
	}
	
	/** Test when only some of the casebases are empty
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test
	public void merge_someempty(){
		Collection<CaseBase> bases = new ArrayList<CaseBase>();
		
		bases.add(new CaseBase());
		bases.add(new CaseBase());
		bases.add(new CaseBase());
		bases.add(this.cb5);
		bases.add(this.cb1);
		bases.add(new CaseBase());
		
		CaseBase merged = CaseBaseMerger.merge(bases);
		
		assertNotNull(merged);
		assertEquals(merged.getCasebaseSize(), 6);	
	}
	
	/** Test when only all of the casebases are empty
	 * 
	 * @author Michael W. Floyd
	 * @since 0.4
	 */
	@Test
	public void merge_allempty(){
		Collection<CaseBase> bases = new ArrayList<CaseBase>();
		
		for(int ii=0;ii<10;ii++){
			bases.add(new CaseBase());
		}
		
		CaseBase merged = CaseBaseMerger.merge(bases);
		
		assertNotNull(merged);
		assertEquals(merged.getCasebaseSize(), 0);
	}
}
