/** RandomCaseBaseTest.java in the package tests.junit.org.JIFSA.tools of the JIFSA project.
    Originally created 02-Oct-08

    Copyright (C) 2008 Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.JIFSA.tools;

import static org.junit.Assert.assertEquals;

import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.tools.RandomCaseBase;
import org.junit.Test;

/** Unit tests for the org.JIFSA.tools.RandomCaseBase class
 * 
 * @author Michael W. Floyd
 * @since 0.5
 */
public class RandomCaseBaseTest {

	/** Test when a null CaseBase is given
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test(expected=IllegalArgumentException.class)
	public void random_nullCB(){
		RandomCaseBase.random(null, 10);
	}
	
	/** Test when a zero sized number of cases requested
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test(expected=IllegalArgumentException.class)
	public void random_zero(){
		CaseBase cb = new CaseBase();
		cb.addCase(new Case());
		
		RandomCaseBase.random(cb, 0);
		
	}
	
	/** Test when a negative sized number of cases requested
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test(expected=IllegalArgumentException.class)
	public void random_negative(){
		CaseBase cb = new CaseBase();
		cb.addCase(new Case());
		
		RandomCaseBase.random(cb, -1);
	}
	
	/** Test when a number larger than size of CaseBase is given
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test(expected=IllegalArgumentException.class)
	public void random_larger(){
		CaseBase cb = new CaseBase();
		cb.addCase(new Case());
		
		RandomCaseBase.random(cb, 2);
	}
	
	/** Test when a valid number of cases requested
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	@Test
	public void random_valid(){
		//test making sure creating the object doesn't cause a problem,
		//even though we use it in a static context
		new RandomCaseBase();
		
		CaseBase cb = new CaseBase();
		
		for(int ii=0;ii<100;ii++){
			cb.addCase(new Case());
		}
		
		CaseBase newCB = RandomCaseBase.random(cb, 37);
		assertEquals(newCB.getCasebaseSize(), 37);
	}
}
