/*
 * Decompiled with CFR 0.152.
 */
package org.RCSImitate;

import org.JIFSA.Agent;
import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.RCSImitate.RCSImitate;
import org.RCSImitate.Vision;
import org.RCSImitate.soccersimactions.CatchAction;
import org.RCSImitate.soccersimactions.DashAction;
import org.RCSImitate.soccersimactions.KickAction;
import org.RCSImitate.soccersimactions.TurnAction;
import org.RCSImitate.soccersimactions.TurnNeckAction;

public class Brain
extends Thread {
    private volatile boolean m_timeOver;
    private Agent m_agent;
    private Vision m_vision;
    private RCSImitate m_robot;

    public Brain(Agent agent, RCSImitate rCSImitate) {
        if (agent == null || rCSImitate == null) {
            throw new IllegalArgumentException("Null value given to Brain constructor.");
        }
        this.m_timeOver = false;
        this.m_agent = agent;
        this.m_robot = rCSImitate;
        this.m_vision = new Vision();
    }

    @Override
    public void run() {
        while (!this.m_timeOver) {
            AgentAction agentAction;
            if (this.m_vision.hasBeenSeen()) continue;
            AgentInputs agentInputs = this.m_vision.getCurrentVision();
            AgentAction agentAction2 = this.m_agent.senseEnvironment(agentInputs);
            if (agentAction2 == null) {
                System.out.println("No action returned. You may need to filter CaseBase to remove Cases with no actions!");
                continue;
            }
            String string = agentAction2.getActionName();
            if (string.equals(DashAction.c_DASH)) {
                agentAction = (DashAction)agentAction2;
                this.m_robot.dash(agentAction.getDashPower());
                continue;
            }
            if (string.equals(TurnAction.c_TURN)) {
                agentAction = (TurnAction)agentAction2;
                this.m_robot.turn(agentAction.getTurnAngle());
                continue;
            }
            if (string.equals(KickAction.c_KICK)) {
                agentAction = (KickAction)agentAction2;
                this.m_robot.kick(agentAction.getKickPower(), agentAction.getKickAngle());
                continue;
            }
            if (string.equals(TurnNeckAction.c_TURNNECK)) {
                agentAction = (TurnNeckAction)agentAction2;
                this.m_robot.turn_neck(agentAction.getTurnNeckAngle());
                continue;
            }
            if (string.equals(CatchAction.c_CATCH)) {
                agentAction = (CatchAction)agentAction2;
                continue;
            }
            System.out.println("I was not expecting action: " + string);
        }
    }

    public void see(AgentInputs agentInputs) {
        this.m_vision.store(agentInputs);
    }

    public void setTimeOver(boolean bl) {
        this.m_timeOver = bl;
    }
}

