/*
 * Decompiled with CFR 0.152.
 */
package org.RCSImitate;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.swing.SwingUtilities;
import org.JIFSA.Agent;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.SensoryItem;
import org.JIFSA.preprocessing.filters.casebasefilter.NoActionsFilter;
import org.JIFSA.reasoning.Weights;
import org.JIFSA.reasoning.actionselection.ActionSelection;
import org.JIFSA.reasoning.actionselection.ClosestNeighbourSelection;
import org.JIFSA.reasoning.actionselection.actionestimation.ActionEstimation;
import org.JIFSA.reasoning.actionselection.actionestimation.LastActionEstimate;
import org.JIFSA.reasoning.casebasesearch.CaseBaseSearch;
import org.JIFSA.reasoning.casebasesearch.NearestNeighbourSearch;
import org.JIFSA.reasoning.distance.DistanceCalculation;
import org.JIFSA.reasoning.distance.EqualityDistanceAlgorithm;
import org.JIFSA.reasoning.distance.GlobalDistanceMeasure;
import org.JIFSA.reasoning.distance.globaldistance.OrderIndexMatchingAlgorithm;
import org.JIFSA.reasoning.distance.penalty.ConstantPenalty;
import org.JIFSA.reasoning.distance.penalty.PenaltyDistance;
import org.JIFSA.reasoning.distance.spatial2D.PolarDistanceAlgorithm;
import org.JIFSA.sensoryItems.Spatial2DObject;
import org.JIFSA.tools.CaseBaseIO;
import org.JIFSA.tools.CaseEvent;
import org.JIFSA.tools.CaseEventListener;
import org.RCSImitate.Brain;
import org.RCSImitate.gui.RCSIFrame;
import org.RCSImitate.parsingListeners.rcscenesParser;
import org.RCSImitate.sensoryItems.BallFeature;
import org.RCSImitate.sensoryItems.TeammatePlayerFeature;
import org.RCSLogServer.LogParser.LogParser;
import org.RCSLogServer.LogParser.ParsingEventListener;

public class RCSImitate
implements Runnable,
CaseEventListener {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_HOSTPORT = 6000;
    public static final String DEFAULT_TEAMNAME = "Carleton";
    public static final String DEFAULT_CASEBASEFILE = "default.cb";
    private static final int MINNUMARGS = 2;
    private static final int MSG_SIZE = 4096;
    private DatagramSocket m_socket = new DatagramSocket();
    private InetAddress m_serverhost;
    private int m_serverport;
    private String m_teamname;
    private volatile boolean m_timeOver = false;
    private Brain m_brain = null;
    private Agent m_agent;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RCSIFrame rCSIFrame = new RCSIFrame();
                    rCSIFrame.setLocationRelativeTo(null);
                    rCSIFrame.setVisible(true);
                }
            });
        } else {
            RCSImitate.parseAndRun(stringArray);
        }
    }

    private static void parseAndRun(String[] stringArray) {
        String string = DEFAULT_HOSTNAME;
        int n = 6000;
        String string2 = DEFAULT_TEAMNAME;
        String string3 = DEFAULT_CASEBASEFILE;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].compareTo("-host") == 0) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].compareTo("-port") == 0) {
                n = Integer.parseInt(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].compareTo("-team") == 0) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].compareTo("-casebasename") == 0) {
                string3 = stringArray[i + 1];
                continue;
            }
            RCSImitate.displayErrorMessage();
            return;
        }
        System.out.println("Loading the Case Base ...");
        CaseBase caseBase = CaseBaseIO.loadCaseBase((String)string3);
        NoActionsFilter noActionsFilter = new NoActionsFilter();
        System.out.println("Filtering the Case Base ...");
        caseBase = noActionsFilter.filter(caseBase);
        NearestNeighbourSearch nearestNeighbourSearch = new NearestNeighbourSearch(1);
        SensoryItem.setDistanceCalculation((DistanceCalculation)new EqualityDistanceAlgorithm());
        SensoryItem.setPenaltyDistanceCalculation((PenaltyDistance)new ConstantPenalty(100.0f));
        Spatial2DObject.setDistanceCalculation((DistanceCalculation)new PolarDistanceAlgorithm());
        Weights weights = new Weights(0.0f);
        weights.setWeight(BallFeature.c_BALL, 1.0f);
        weights.setWeight(TeammatePlayerFeature.c_TEAMMATE, 1.0f);
        OrderIndexMatchingAlgorithm orderIndexMatchingAlgorithm = new OrderIndexMatchingAlgorithm(weights);
        Case.setGlobalDistanceCalculation((GlobalDistanceMeasure)orderIndexMatchingAlgorithm);
        LastActionEstimate lastActionEstimate = new LastActionEstimate();
        ClosestNeighbourSelection closestNeighbourSelection = new ClosestNeighbourSelection((ActionEstimation)lastActionEstimate);
        Agent agent = new Agent(caseBase, (CaseBaseSearch)nearestNeighbourSearch, (ActionSelection)closestNeighbourSelection);
        RCSImitate rCSImitate = null;
        try {
            rCSImitate = new RCSImitate(string, n, string2, agent);
        }
        catch (SocketException socketException) {
            System.err.println(socketException.getMessage());
            return;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println(unknownHostException.getMessage());
            return;
        }
        new Thread(rCSImitate).start();
    }

    public RCSImitate(String string, int n, String string2, Agent agent) throws SocketException, UnknownHostException {
        this.m_serverhost = InetAddress.getByName(string);
        this.m_serverport = n;
        this.m_teamname = string2;
        this.m_agent = agent;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception exception) {
            System.out.println("Fatal Error: " + exception.getMessage());
        }
    }

    public void execute() throws IOException {
        byte[] byArray = new byte[4096];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 4096);
        System.out.println("Sending init command to server...");
        this.init();
        LogParser logParser = new LogParser();
        rcscenesParser rcscenesParser2 = new rcscenesParser(this.m_teamname);
        rcscenesParser2.addCEListener(this);
        logParser.addPEListener((ParsingEventListener)rcscenesParser2);
        System.out.println("Waiting for response...");
        this.m_socket.receive(datagramPacket);
        String string = new String(datagramPacket.getData());
        logParser.parse(string.trim());
        this.m_serverport = datagramPacket.getPort();
        System.out.println("Connection established.");
        while (!this.m_timeOver) {
            try {
                logParser.parse(this.receive().trim());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
        System.out.println("Game over. Shutting down.");
    }

    public void move(double d, double d2) {
        this.send("(move " + Double.toString(d) + " " + Double.toString(d2) + ")");
    }

    public void turn(double d) {
        this.send("(turn " + Double.toString(d) + ")");
    }

    public void turn_neck(double d) {
        this.send("(turn_neck " + Double.toString(d) + ")");
    }

    public void dash(double d) {
        this.send("(dash " + Double.toString(d) + ")");
    }

    public void kick(double d, double d2) {
        this.send("(kick " + Double.toString(d) + " " + Double.toString(d2) + ")");
    }

    public void say(String string) {
        this.send("(say " + string + ")");
    }

    public void changeView(String string, String string2) {
        this.send("(change_view " + string + " " + string2 + ")");
    }

    public void catchBall(String string) {
        this.send("(catch " + string + ")");
    }

    protected void init() {
        this.send("(init " + this.m_teamname + " (version 8))");
    }

    private void send(String string) {
        byte[] byArray = new byte[4096];
        byArray = string.getBytes();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.m_serverhost, this.m_serverport);
        try {
            this.m_socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            System.err.println("Socket sending error : " + iOException);
        }
    }

    private String receive() {
        byte[] byArray = new byte[4096];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 4096);
        try {
            this.m_socket.receive(datagramPacket);
        }
        catch (IOException iOException) {
            System.err.println("Socket receiving error : " + iOException);
        }
        return new String(byArray);
    }

    public void Connecting(CaseEvent caseEvent) {
    }

    public void Connected(CaseEvent caseEvent) {
        this.m_brain = new Brain(this.m_agent, this);
        new Thread(this.m_brain).start();
    }

    public void TeamNameMissing(CaseEvent caseEvent) {
    }

    public void GotInputs(CaseEvent caseEvent) {
        AgentInputs agentInputs = caseEvent.getAgentInputs();
        this.m_brain.see(agentInputs);
    }

    public void GotActions(CaseEvent caseEvent) {
    }

    public void TimeOver(CaseEvent caseEvent) {
        this.m_timeOver = true;
        this.m_brain.setTimeOver(true);
    }

    private static void displayErrorMessage() {
        System.out.println("Invalid params");
    }
}

