/*
 * Decompiled with CFR 0.152.
 */
package org.RCSImitate.casebasebuilder;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.tools.CaseBaseIO;
import org.JIFSA.tools.CaseEvent;
import org.JIFSA.tools.CaseEventListener;
import org.RCSImitate.parsingListeners.rcscenesParser;
import org.RCSLogServer.LogParser.LogParser;
import org.RCSLogServer.LogParser.ParsedLine;
import org.RCSLogServer.LogParser.ParsingEventListener;

public class LogFile2CaseBase
implements CaseEventListener {
    private String m_logFileName;
    private String m_outputFileName;
    private CaseBase m_casebase;
    private String m_teamName;
    private AgentInputs m_lastInputs;
    private ArrayList<AgentAction> m_actionList;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            LogFile2CaseBase.displayUsage();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = "";
        if (stringArray.length > 2) {
            string3 = stringArray[2];
        }
        LogFile2CaseBase logFile2CaseBase = new LogFile2CaseBase(string, string2, string3);
        try {
            logFile2CaseBase.parseLogFile();
        }
        catch (IOException iOException) {
            System.err.println("Error parsing log file: " + iOException.getMessage());
            return;
        }
        System.out.println("Writing Cases to file...");
        try {
            logFile2CaseBase.writeCaseBaseFile();
        }
        catch (IOException iOException) {
            System.err.println("Error writing to output file: " + iOException.getMessage());
        }
        System.out.println("Finished!");
    }

    public LogFile2CaseBase(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("Null parameters given to constructor.");
        }
        this.m_logFileName = string;
        this.m_outputFileName = string2;
        this.m_teamName = string3;
        this.m_lastInputs = new AgentInputs();
        this.m_actionList = new ArrayList();
        this.m_casebase = new CaseBase();
    }

    public void Connecting(CaseEvent caseEvent) {
        this.m_teamName = caseEvent.getTeamName();
        System.out.println("Got team name from the Log File: '" + this.m_teamName + "'");
    }

    public void Connected(CaseEvent caseEvent) {
    }

    public void TeamNameMissing(CaseEvent caseEvent) {
        System.err.println("The Log File doesn't contain initialization messages.");
        System.err.println("Please run again with the third parameter.");
        System.err.println(" ");
        LogFile2CaseBase.displayUsage();
        System.exit(1);
    }

    public void GotInputs(CaseEvent caseEvent) {
        this.m_lastInputs = caseEvent.getAgentInputs();
    }

    public void GotActions(CaseEvent caseEvent) {
        this.m_actionList = caseEvent.getAgentActions();
        Case case_ = new Case(this.m_lastInputs, this.m_actionList);
        this.m_casebase.addCase(case_);
    }

    public void TimeOver(CaseEvent caseEvent) {
    }

    public void parseLogFile() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_logFileName));
        LogParser logParser = new LogParser();
        rcscenesParser rcscenesParser2 = new rcscenesParser(this.m_teamName);
        rcscenesParser2.addCEListener(this);
        logParser.addPEListener((ParsingEventListener)rcscenesParser2);
        ParsedLine parsedLine = null;
        System.out.println("Reading log data...");
        while ((string = bufferedReader.readLine()) != null) {
            parsedLine = logParser.parse(string);
        }
        rcscenesParser2.EoF();
        System.out.println("Finished reading log file.");
        System.out.println(this.m_casebase.getCasebaseSize() + " Cases were extracted.");
        bufferedReader.close();
    }

    public CaseBase getCaseBase() {
        return new CaseBase(this.m_casebase);
    }

    public void writeCaseBaseFile() throws IOException {
        CaseBaseIO.saveCaseBase((CaseBase)this.m_casebase, (String)this.m_outputFileName);
    }

    private static void displayUsage() {
        System.err.println("LogFile2CaseBase - converts captured Robocup log files to a CaseBase");
        System.err.println("\nUsage: java LogFile2CaseBase in-file out-file teamName");
        System.err.println("in-file: The name of the log file");
        System.err.println("out-file: The name of the file the CaseBase will be writen to");
        System.err.println("teamName: The name of the team the player was on when the log file was created.");
        System.err.println("          Only required if the Log File doesn't start with (init) messages.");
    }
}

