/*
 * Decompiled with CFR 0.152.
 */
package org.RCSImitate.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.JIFSA.Agent;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.SensoryItem;
import org.JIFSA.preprocessing.filters.casebasefilter.NoActionsFilter;
import org.JIFSA.reasoning.Weights;
import org.JIFSA.reasoning.actionselection.ActionSelection;
import org.JIFSA.reasoning.actionselection.ClosestNeighbourSelection;
import org.JIFSA.reasoning.actionselection.actionestimation.ActionEstimation;
import org.JIFSA.reasoning.actionselection.actionestimation.LastActionEstimate;
import org.JIFSA.reasoning.casebasesearch.CaseBaseSearch;
import org.JIFSA.reasoning.casebasesearch.NearestNeighbourSearch;
import org.JIFSA.reasoning.distance.DistanceCalculation;
import org.JIFSA.reasoning.distance.EqualityDistanceAlgorithm;
import org.JIFSA.reasoning.distance.GlobalDistanceMeasure;
import org.JIFSA.reasoning.distance.globaldistance.OrderIndexMatchingAlgorithm;
import org.JIFSA.reasoning.distance.penalty.ConstantPenalty;
import org.JIFSA.reasoning.distance.penalty.PenaltyDistance;
import org.JIFSA.reasoning.distance.spatial2D.PolarDistanceAlgorithm;
import org.JIFSA.sensoryItems.Spatial2DObject;
import org.JIFSA.tools.CaseBaseIO;
import org.RCSImitate.RCSImitate;
import org.RCSImitate.casebasebuilder.LogFile2CaseBase;
import org.RCSImitate.sensoryItems.BallFeature;
import org.RCSImitate.sensoryItems.TeammatePlayerFeature;

public class RCSIFrame
extends JFrame {
    private static final long serialVersionUID = -8512961489663928526L;
    private JMenuBar jMenuBar;
    private JMenu jMenuAbout;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemHelpLog2CaseBase;
    private JTabbedPane jTabbedPane;
    private JPanel jPanelLog2CaseBase;
    private JPanel jPanelRunAgent;
    private JTextField jInputFileName;
    private JLabel jLabelPort;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldServer;
    private JLabel jLabelServer;
    private JTextField jTextFieldTeamName;
    private JLabel jLabelTeamName;
    private JTextField jTeamName;
    private JTextField jOutputFileName;
    private JButton jLogFileNameButton;
    private JButton jCaseBaseFileNameButton;
    private JButton jButtonLog2CaseBase;
    private JSeparator jSeparatorRunAgent2;
    private JLabel jLabelCaseBaseFile;
    private JTextField jTextFieldCBFile;
    private JButton jButtonCaseBaseFile;
    private JSeparator jSeparatorRunAgent1;
    private JButton jButtonSpawnAgent;
    private JFileChooser jFileChooser;
    private final String c_ABOUTMESSAGE = "RCSImitate Graphical User Interface v0.2 \nCopyright 2008 Michael W. Floyd";
    private final String c_HELPLOG2CASEBASEMESSAGE = "Log File: RoboCup log file generated by LogServer program \nCase Base File: File to output the case base to \nTeam Name: The name of the team logged in the log file";

    public RCSIFrame() {
        this.buildGUI();
    }

    private void buildGUI() {
        this.setTitle("RCSImitate");
        this.jFileChooser = new JFileChooser();
        this.setDefaultCloseOperation(2);
        this.jTabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.jTabbedPane, "Center");
        this.jPanelLog2CaseBase = new JPanel();
        this.jTabbedPane.addTab("Log2CaseBase", null, this.jPanelLog2CaseBase, null);
        this.jPanelLog2CaseBase.setLayout(null);
        this.jButtonLog2CaseBase = new JButton();
        this.jPanelLog2CaseBase.add(this.jButtonLog2CaseBase);
        this.jButtonLog2CaseBase.setText("Log2CaseBase");
        this.jButtonLog2CaseBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RCSIFrame.this.runLog2CaseBase();
            }
        });
        this.jButtonLog2CaseBase.setLayout(null);
        this.jButtonLog2CaseBase.setBounds(106, 208, 141, 21);
        this.jInputFileName = new JTextField();
        this.jPanelLog2CaseBase.add(this.jInputFileName);
        this.jInputFileName.setText("Log File Name...");
        this.jInputFileName.setBounds(106, 23, 245, 21);
        this.jLogFileNameButton = new JButton();
        this.jPanelLog2CaseBase.add(this.jLogFileNameButton);
        this.jLogFileNameButton.setText("Select ...");
        this.jLogFileNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RCSIFrame.this.selectLogFile();
            }
        });
        this.jLogFileNameButton.setLayout(null);
        this.jLogFileNameButton.setBounds(12, 23, 83, 21);
        this.jCaseBaseFileNameButton = new JButton();
        this.jPanelLog2CaseBase.add(this.jCaseBaseFileNameButton);
        this.jCaseBaseFileNameButton.setText("Select ...");
        this.jCaseBaseFileNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RCSIFrame.this.selectCaseBaseFile();
            }
        });
        this.jCaseBaseFileNameButton.setLayout(null);
        this.jCaseBaseFileNameButton.setBounds(12, 79, 83, 21);
        this.jOutputFileName = new JTextField();
        this.jPanelLog2CaseBase.add(this.jOutputFileName);
        this.jOutputFileName.setText("Case Base File Name...");
        this.jOutputFileName.setBounds(106, 79, 245, 21);
        this.jTeamName = new JTextField();
        this.jPanelLog2CaseBase.add(this.jTeamName);
        this.jTeamName.setText("Team Name...");
        this.jTeamName.setBounds(106, 133, 116, 21);
        this.jLabelTeamName = new JLabel();
        this.jPanelLog2CaseBase.add(this.jLabelTeamName);
        this.jLabelTeamName.setText("Team Name:");
        this.jLabelTeamName.setBounds(12, 136, 82, 14);
        this.jPanelRunAgent = new JPanel();
        this.jTabbedPane.addTab("Run Agent", null, this.jPanelRunAgent, null);
        this.jPanelRunAgent.setLayout(null);
        this.jLabelTeamName = new JLabel();
        this.jPanelRunAgent.add(this.jLabelTeamName);
        this.jLabelTeamName.setText("Team Name");
        this.jLabelTeamName.setBounds(102, 14, 68, 14);
        this.jTextFieldTeamName = new JTextField();
        this.jPanelRunAgent.add(this.jTextFieldTeamName);
        this.jTextFieldTeamName.setText("Carleton");
        this.jTextFieldTeamName.setBounds(170, 11, 134, 22);
        this.jLabelServer = new JLabel();
        this.jPanelRunAgent.add(this.jLabelServer);
        this.jLabelServer.setText("Server");
        this.jLabelServer.setBounds(102, 37, 68, 14);
        this.jTextFieldServer = new JTextField();
        this.jPanelRunAgent.add(this.jTextFieldServer);
        this.jTextFieldServer.setText("localhost");
        this.jTextFieldServer.setBounds(170, 33, 134, 23);
        this.jTextFieldPort = new JTextField();
        this.jPanelRunAgent.add(this.jTextFieldPort);
        this.jTextFieldPort.setText("6000");
        this.jTextFieldPort.setBounds(170, 56, 134, 23);
        this.jLabelPort = new JLabel();
        this.jPanelRunAgent.add(this.jLabelPort);
        this.jLabelPort.setText("Port");
        this.jLabelPort.setBounds(103, 60, 68, 14);
        this.jButtonSpawnAgent = new JButton();
        this.jPanelRunAgent.add(this.jButtonSpawnAgent);
        this.jButtonSpawnAgent.setText("Spawn Agent");
        this.jButtonSpawnAgent.setBounds(132, 265, 109, 21);
        this.jButtonSpawnAgent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RCSIFrame.this.spawnAgent();
            }
        });
        this.jSeparatorRunAgent1 = new JSeparator();
        this.jPanelRunAgent.add(this.jSeparatorRunAgent1);
        this.jSeparatorRunAgent1.setBounds(58, 98, 298, 11);
        this.jButtonCaseBaseFile = new JButton();
        this.jPanelRunAgent.add(this.jButtonCaseBaseFile);
        this.jButtonCaseBaseFile.setBounds(22, 137, 81, 23);
        this.jButtonCaseBaseFile.setText("Select...");
        this.jTextFieldCBFile = new JTextField();
        this.jPanelRunAgent.add(this.jTextFieldCBFile);
        this.jTextFieldCBFile.setBounds(132, 138, 224, 21);
        this.jTextFieldCBFile.setText("default.cb");
        this.jLabelCaseBaseFile = new JLabel();
        this.jPanelRunAgent.add(this.jLabelCaseBaseFile);
        this.jLabelCaseBaseFile.setText("Case Base File");
        this.jLabelCaseBaseFile.setBounds(138, 109, 122, 14);
        this.jSeparatorRunAgent2 = new JSeparator();
        this.jPanelRunAgent.add(this.jSeparatorRunAgent2);
        this.jSeparatorRunAgent2.setBounds(58, 182, 298, 11);
        this.jMenuBar = new JMenuBar();
        this.setJMenuBar(this.jMenuBar);
        this.jMenuAbout = new JMenu();
        this.jMenuBar.add(this.jMenuAbout);
        this.jMenuAbout.setText("About");
        this.jMenuItemAbout = new JMenuItem();
        this.jMenuAbout.add(this.jMenuItemAbout);
        this.jMenuItemAbout.setText("About RCSImitate");
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RCSIFrame.this.displayAboutMessage();
            }
        });
        this.jMenuHelp = new JMenu();
        this.jMenuBar.add(this.jMenuHelp);
        this.jMenuHelp.setText("Help");
        this.jMenuItemHelpLog2CaseBase = new JMenuItem();
        this.jMenuHelp.add(this.jMenuItemHelpLog2CaseBase);
        this.jMenuItemHelpLog2CaseBase.setText("LogFile2CaseBase");
        this.jMenuItemHelpLog2CaseBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RCSIFrame.this.displayHelpLog2CaseBaseMessage();
            }
        });
        this.pack();
        this.setSize(400, 650);
    }

    private void selectLogFile() {
        int n = this.jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = this.jFileChooser.getSelectedFile().getAbsolutePath();
            this.jInputFileName.setText(string);
        }
    }

    private void selectCaseBaseFile() {
        int n = this.jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = this.jFileChooser.getSelectedFile().getAbsolutePath();
            this.jOutputFileName.setText(string);
        }
    }

    private void runLog2CaseBase() {
        String string = this.jInputFileName.getText();
        String string2 = this.jOutputFileName.getText();
        String string3 = this.jTeamName.getText();
        try {
            LogFile2CaseBase logFile2CaseBase = new LogFile2CaseBase(string, string2, string3);
            logFile2CaseBase.parseLogFile();
            logFile2CaseBase.writeCaseBaseFile();
            JOptionPane.showMessageDialog(this, "Case base written to " + string2, "Complete", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error: " + exception.getMessage(), "Error", 0);
        }
    }

    private void displayAboutMessage() {
        JOptionPane.showMessageDialog(this, this.c_ABOUTMESSAGE, "About RCSImitate", -1);
    }

    private void displayHelpLog2CaseBaseMessage() {
        JOptionPane.showMessageDialog(this, this.c_HELPLOG2CASEBASEMESSAGE, "Help", -1);
    }

    private void spawnAgent() {
        String string = this.jTextFieldServer.getText();
        String string2 = this.jTextFieldPort.getText();
        String string3 = this.jTextFieldTeamName.getText();
        String string4 = this.jTextFieldCBFile.getText();
        try {
            CaseBase caseBase = CaseBaseIO.loadCaseBase((String)string4);
            NoActionsFilter noActionsFilter = new NoActionsFilter();
            caseBase = noActionsFilter.filter(caseBase);
            NearestNeighbourSearch nearestNeighbourSearch = new NearestNeighbourSearch(1);
            SensoryItem.setDistanceCalculation((DistanceCalculation)new EqualityDistanceAlgorithm());
            SensoryItem.setPenaltyDistanceCalculation((PenaltyDistance)new ConstantPenalty(100.0f));
            Spatial2DObject.setDistanceCalculation((DistanceCalculation)new PolarDistanceAlgorithm());
            Weights weights = new Weights(0.0f);
            weights.setWeight(BallFeature.c_BALL, 1.0f);
            weights.setWeight(TeammatePlayerFeature.c_TEAMMATE, 1.0f);
            OrderIndexMatchingAlgorithm orderIndexMatchingAlgorithm = new OrderIndexMatchingAlgorithm(weights);
            Case.setGlobalDistanceCalculation((GlobalDistanceMeasure)orderIndexMatchingAlgorithm);
            LastActionEstimate lastActionEstimate = new LastActionEstimate();
            ClosestNeighbourSelection closestNeighbourSelection = new ClosestNeighbourSelection((ActionEstimation)lastActionEstimate);
            Agent agent = new Agent(caseBase, (CaseBaseSearch)nearestNeighbourSearch, (ActionSelection)closestNeighbourSelection);
            int n = new Integer(string2);
            RCSImitate rCSImitate = new RCSImitate(string, n, string3, agent);
            new Thread(rCSImitate).start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error: " + exception.getMessage(), "Error", 0);
        }
    }
}

