/*
 * Decompiled with CFR 0.152.
 */
package org.RCSImitate.parsingListeners;

import java.util.ArrayList;
import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.SensoryItem;
import org.JIFSA.tools.CaseEvent;
import org.JIFSA.tools.CaseEventListener;
import org.RCSImitate.sensoryItems.BallFeature;
import org.RCSImitate.sensoryItems.FlagFeature;
import org.RCSImitate.sensoryItems.GoalFeature;
import org.RCSImitate.sensoryItems.LineFeature;
import org.RCSImitate.sensoryItems.OpponentPlayerFeature;
import org.RCSImitate.sensoryItems.PlayerFeature;
import org.RCSImitate.sensoryItems.RoboCupSimulation2DSpatialObject;
import org.RCSImitate.sensoryItems.TeammatePlayerFeature;
import org.RCSImitate.sensoryItems.UnknownPlayerFeature;
import org.RCSImitate.soccersimactions.CatchAction;
import org.RCSImitate.soccersimactions.DashAction;
import org.RCSImitate.soccersimactions.KickAction;
import org.RCSImitate.soccersimactions.TurnAction;
import org.RCSImitate.soccersimactions.TurnNeckAction;
import org.RCSLogServer.LogParser.ParsingEvent;
import org.RCSLogServer.LogParser.ParsingEventListenerAdapter;

public class rcscenesParser
extends ParsingEventListenerAdapter {
    private AgentInputs m_lastInputs;
    private ArrayList<AgentAction> m_actionList;
    private String m_teamName;
    private ArrayList<CaseEventListener> CEListeners;

    public rcscenesParser(String string) {
        this.m_teamName = string;
        this.m_lastInputs = new AgentInputs();
        this.m_actionList = new ArrayList();
        this.CEListeners = new ArrayList();
    }

    public void addCEListener(CaseEventListener caseEventListener) {
        this.CEListeners.add(caseEventListener);
    }

    public void removeCEListener(CaseEventListener caseEventListener) {
        this.CEListeners.remove(caseEventListener);
    }

    public void ClientInit(ParsingEvent parsingEvent) {
        this.m_teamName = parsingEvent.get("team_name");
        CaseEvent caseEvent = new CaseEvent((Object)this, this.m_teamName);
        for (CaseEventListener caseEventListener : this.CEListeners) {
            caseEventListener.Connecting(caseEvent);
        }
    }

    public void ServerInit(ParsingEvent parsingEvent) {
        CaseEvent caseEvent = new CaseEvent((Object)this);
        for (CaseEventListener caseEventListener : this.CEListeners) {
            caseEventListener.Connected(caseEvent);
        }
    }

    public void Sensing(ParsingEvent parsingEvent) {
        if (this.m_teamName.equals("")) {
            CaseEvent caseEvent = new CaseEvent((Object)this);
            for (CaseEventListener caseEventListener : this.CEListeners) {
                caseEventListener.TeamNameMissing(caseEvent);
            }
        }
    }

    public void SeeReceived(ParsingEvent parsingEvent) {
        if (this.m_lastInputs.getNumberSensoryItems() > 0) {
            CaseEvent caseEvent = new CaseEvent((Object)this, this.m_actionList);
            for (CaseEventListener caseEventListener : this.CEListeners) {
                caseEventListener.GotActions(caseEvent);
            }
        }
        this.m_lastInputs = new AgentInputs();
        this.m_actionList = new ArrayList();
    }

    public void EoF() {
        if (this.m_lastInputs.getNumberSensoryItems() > 0) {
            CaseEvent caseEvent = new CaseEvent((Object)this, this.m_actionList);
            for (CaseEventListener caseEventListener : this.CEListeners) {
                caseEventListener.GotActions(caseEvent);
            }
        }
    }

    public void SeeParsed(ParsingEvent parsingEvent) {
        CaseEvent caseEvent = new CaseEvent((Object)this, this.m_lastInputs);
        for (CaseEventListener caseEventListener : this.CEListeners) {
            caseEventListener.GotInputs(caseEvent);
        }
    }

    private void setObjectPosition(RoboCupSimulation2DSpatialObject roboCupSimulation2DSpatialObject, ParsingEvent parsingEvent) {
        if (parsingEvent.contains("dir_change")) {
            roboCupSimulation2DSpatialObject.setDirectionChange(Float.parseFloat(parsingEvent.get("dir_change")));
        }
        if (parsingEvent.contains("dist_change")) {
            roboCupSimulation2DSpatialObject.setDistanceChange(Float.parseFloat(parsingEvent.get("dist_change")));
        }
        if (parsingEvent.contains("direction")) {
            roboCupSimulation2DSpatialObject.setDirection(Float.parseFloat(parsingEvent.get("direction")));
        }
        if (parsingEvent.contains("distance")) {
            roboCupSimulation2DSpatialObject.setDistance(Float.parseFloat(parsingEvent.get("distance")));
        }
    }

    public void Player(ParsingEvent parsingEvent) {
        String string;
        PlayerFeature playerFeature = null;
        playerFeature = parsingEvent.contains("team") ? ((string = parsingEvent.get("team")).equals(this.m_teamName) ? new TeammatePlayerFeature() : new OpponentPlayerFeature()) : new UnknownPlayerFeature();
        if (parsingEvent.contains("player_number")) {
            playerFeature.setUniformNumber(Integer.parseInt(parsingEvent.get("player_number")));
        }
        if (parsingEvent.contains("goalie")) {
            playerFeature.setIsGoalie(true);
        }
        this.setObjectPosition(playerFeature, parsingEvent);
        this.m_lastInputs.addSensoryItem((SensoryItem)playerFeature);
    }

    public void Goal(ParsingEvent parsingEvent) {
        GoalFeature goalFeature = new GoalFeature();
        if (parsingEvent.contains("name")) {
            goalFeature.setSide(parsingEvent.get("name"));
        }
        this.setObjectPosition(goalFeature, parsingEvent);
        this.m_lastInputs.addSensoryItem((SensoryItem)goalFeature);
    }

    public void Ball(ParsingEvent parsingEvent) {
        BallFeature ballFeature = new BallFeature();
        this.setObjectPosition(ballFeature, parsingEvent);
        this.m_lastInputs.addSensoryItem((SensoryItem)ballFeature);
    }

    public void Flag(ParsingEvent parsingEvent) {
        FlagFeature flagFeature = new FlagFeature();
        String string = parsingEvent.get("name");
        if (parsingEvent.contains("Box")) {
            flagFeature.setBox(parsingEvent.get("Box"));
        }
        if (parsingEvent.contains("hp")) {
            flagFeature.setHorizontalPosition(parsingEvent.get("hp"));
        }
        if (parsingEvent.contains("vp")) {
            flagFeature.setVerticalPosition(parsingEvent.get("vp"));
        }
        if (parsingEvent.contains("flag_number")) {
            flagFeature.setFlagNumber(Integer.parseInt(parsingEvent.get("flag_number")));
            flagFeature.setOutOfBounds(true);
        } else {
            flagFeature.setOutOfBounds(false);
        }
        this.setObjectPosition(flagFeature, parsingEvent);
        this.m_lastInputs.addSensoryItem((SensoryItem)flagFeature);
    }

    public void Line(ParsingEvent parsingEvent) {
        LineFeature lineFeature = new LineFeature();
        if (parsingEvent.contains("name")) {
            lineFeature.setLocation(parsingEvent.get("name"));
        }
        this.setObjectPosition(lineFeature, parsingEvent);
        this.m_lastInputs.addSensoryItem((SensoryItem)lineFeature);
    }

    public void Catch(ParsingEvent parsingEvent) {
        CatchAction catchAction = new CatchAction();
        this.m_actionList.add(catchAction);
    }

    public void Dash(ParsingEvent parsingEvent) {
        float f = Float.parseFloat(parsingEvent.get("power"));
        DashAction dashAction = new DashAction(f);
        this.m_actionList.add(dashAction);
    }

    public void Kick(ParsingEvent parsingEvent) {
        float f = Float.parseFloat(parsingEvent.get("power"));
        float f2 = Float.parseFloat(parsingEvent.get("direction"));
        KickAction kickAction = new KickAction(f, f2);
        this.m_actionList.add(kickAction);
    }

    public void Turn(ParsingEvent parsingEvent) {
        float f = Float.parseFloat(parsingEvent.get("direction"));
        TurnAction turnAction = new TurnAction(f);
        this.m_actionList.add(turnAction);
    }

    public void TurnNeck(ParsingEvent parsingEvent) {
        float f = Float.parseFloat(parsingEvent.get("neck_angle"));
        TurnNeckAction turnNeckAction = new TurnNeckAction(f);
        this.m_actionList.add(turnNeckAction);
    }

    public void Hear(ParsingEvent parsingEvent) {
        String string = parsingEvent.get("who");
        String string2 = parsingEvent.get("what");
        if (string.equals("referee") && string2.equals("time_over")) {
            CaseEvent caseEvent = new CaseEvent((Object)this);
            for (CaseEventListener caseEventListener : this.CEListeners) {
                caseEventListener.TimeOver(caseEvent);
            }
        }
    }
}

