/*
 * Decompiled with CFR 0.152.
 */
package org.RCSImitate.sensoryItems;

import org.RCSImitate.sensoryItems.RoboCupSimulation2DSpatialObject;

public class FlagFeature
extends RoboCupSimulation2DSpatialObject {
    private static final long serialVersionUID = 3877696748585175328L;
    public static String c_FLAG = "RoboCupSimulation.Flag";
    public static String c_NO_BOX = "No Box";
    public static String c_PENALTY_BOX = "p";
    public static String c_GOAL_BOX = "g";
    public static final int c_NO_NUMBER = -1;
    public static String c_UNKNOWN_POSITION = "Unknown";
    public static String c_LEFT = "l";
    public static String c_RIGHT = "r";
    public static String c_CENTER = "c";
    public static String c_TOP = "t";
    public static String c_BOTTOM = "b";
    private boolean m_outOfBounds = false;
    private int m_flagNumber = -1;
    private String m_box = c_NO_BOX;
    private String m_horizontal = c_UNKNOWN_POSITION;
    private String m_vertical = c_UNKNOWN_POSITION;

    public FlagFeature() {
        super(c_FLAG);
    }

    public void setHorizontalPosition(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Horizonal position of a flag set to a null value.");
        }
        if (!(string.equals(c_LEFT) || string.equals(c_RIGHT) || string.equals(c_CENTER) || string.equals(c_TOP) || string.equals(c_BOTTOM))) {
            throw new IllegalArgumentException("Horizonal position of a flag set to an invalid value: " + string);
        }
        this.m_horizontal = string;
    }

    public String getHorizontalPosition() {
        return this.m_horizontal;
    }

    public void setVerticalPosition(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Vertical position of a flag set to a null value.");
        }
        if (!(string.equals(c_TOP) || string.equals(c_BOTTOM) || string.equals(c_CENTER) || string.equals(c_LEFT) || string.equals(c_RIGHT))) {
            throw new IllegalArgumentException("Vertical position of a flag set to an invalid value: " + string);
        }
        this.m_vertical = string;
    }

    public String getVerticalPosition() {
        return this.m_vertical;
    }

    public void setOutOfBounds(boolean bl) {
        this.m_outOfBounds = bl;
    }

    public boolean isOutOfBounds() {
        return this.m_outOfBounds;
    }

    public void setFlagNumber(int n) {
        this.m_flagNumber = n;
    }

    public int getFlagNumber() {
        return this.m_flagNumber;
    }

    public void setBox(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Box location of a flag set to a null value.");
        }
        if (!string.equals(c_GOAL_BOX) && !string.equals(c_PENALTY_BOX)) {
            throw new IllegalArgumentException("Box location of a flag set to an invalid value: " + string);
        }
        this.m_box = string;
    }

    public String getBox() {
        return this.m_box;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof FlagFeature)) {
            return false;
        }
        FlagFeature flagFeature = (FlagFeature)((Object)object);
        if (!super.equals((Object)flagFeature)) {
            return false;
        }
        return this.m_outOfBounds == flagFeature.isOutOfBounds() && this.m_flagNumber == flagFeature.getFlagNumber() && this.m_horizontal.equals(flagFeature.getHorizontalPosition()) && this.m_vertical.equals(flagFeature.getVerticalPosition()) && this.m_box.equals(flagFeature.getBox());
    }
}

