/** Vision.java in the package org.RCSImitate of the RCSImitate project.
    Originally created Mar 3, 2008

    Copyright (C) 2007 - 2008  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.RCSImitate;

import org.JIFSA.AgentInputs;

/** This stores the current inputs of the agent. This class is used to
 * manage the AgentVision seen by the agent so it knowns when it has changed
 * and also to synchronized access to the inputs.
 * 
 * @author Michael W. Floyd
 * @version 0.3
 */
public class Vision {

	private AgentInputs m_currentVision;
	private boolean m_hasBeenSeen;
	
	/** Default constructor sets the current vision of the agent
	 * to null and indicates that the vision has already been 
	 * seen.
	 * 
	 * @author Michael W. Floyd
	 * @0.3 
	 */
	public Vision(){
		this.m_currentVision = null;
		this.m_hasBeenSeen = true;
	}
	
	/** Used to change what the agent can currently see. This
	 * will also change the state of the current vision to unseen.
	 * 
	 * @param ai The AgentInputs that is currently seen.
	 *
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public synchronized void store(AgentInputs ai){
		this.m_currentVision = ai;
		this.m_hasBeenSeen = false;
	}
	
	/** Returns the current vision and sets that this vision
	 * has been seen.
	 * 
	 * @return The current vision.
	 *
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public synchronized AgentInputs getCurrentVision(){
		this.m_hasBeenSeen = true;
		return this.m_currentVision;
	}
	
	/** Returns true if the current vision has been seen already.
	 * If true, then the current AgentInputs object has been 
	 * retrieved using the getCurrentVision() method and has
	 * not been changed since.
	 * 
	 * @return True if seen, false otherwise.
	 *
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public synchronized boolean hasBeenSeen(){
		return this.m_hasBeenSeen;
	}
}
