/** RCSIFrame.java in the package org.RCSImitate.gui of the RCSImitate project.
    Originally created 3-MAR-08

    Copyright (C) 2007 - 2008  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.RCSImitate.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.WindowConstants;

import org.JIFSA.Agent;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.SensoryItem;
import org.JIFSA.sensoryItems.Spatial2DObject;
import org.JIFSA.preprocessing.filters.casebasefilter.NoActionsFilter;
import org.JIFSA.reasoning.Weights;
import org.JIFSA.reasoning.actionselection.ActionSelection;
import org.JIFSA.reasoning.actionselection.ClosestNeighbourSelection;
import org.JIFSA.reasoning.actionselection.actionestimation.ActionEstimation;
import org.JIFSA.reasoning.actionselection.actionestimation.LastActionEstimate;
import org.JIFSA.reasoning.casebasesearch.CaseBaseSearch;
import org.JIFSA.reasoning.casebasesearch.NearestNeighbourSearch;
import org.JIFSA.reasoning.distance.EqualityDistanceAlgorithm;
import org.JIFSA.reasoning.distance.GlobalDistanceMeasure;
import org.JIFSA.reasoning.distance.globaldistance.OrderIndexMatchingAlgorithm;
import org.JIFSA.reasoning.distance.penalty.ConstantPenalty;
import org.JIFSA.reasoning.distance.spatial2D.PolarDistanceAlgorithm;
import org.JIFSA.tools.CaseBaseIO;
import org.RCSImitate.RCSImitate;
import org.RCSImitate.casebasebuilder.LogFile2CaseBase;
import org.RCSImitate.sensoryItems.BallFeature;
import org.RCSImitate.sensoryItems.TeammatePlayerFeature;

/** A GUI that allows the user to perform several tasks.
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class RCSIFrame extends javax.swing.JFrame {
	
	private static final long serialVersionUID = -8512961489663928526L;
	
	//The SWING components
	private JMenuBar jMenuBar;
	private JMenu jMenuAbout;
	private JMenu jMenuHelp;
	private JMenuItem jMenuItemAbout;
	private JMenuItem jMenuItemHelpLog2CaseBase;
	private JTabbedPane jTabbedPane;
	private JPanel jPanelLog2CaseBase;
	private JPanel jPanelRunAgent;
	private JTextField jInputFileName;
	private JLabel jLabelPort;
	private JTextField jTextFieldPort;
	private JTextField jTextFieldServer;
	private JLabel jLabelServer;
	private JTextField jTextFieldTeamName;
	private JLabel jLabelTeamName;
	private JTextField jTeamName;
	private JTextField jOutputFileName;
	private JButton jLogFileNameButton;
	private JButton jCaseBaseFileNameButton;
	private JButton jButtonLog2CaseBase;
	private JSeparator jSeparatorRunAgent2;
	private JLabel jLabelCaseBaseFile;
	private JTextField jTextFieldCBFile;
	private JButton jButtonCaseBaseFile;
	private JSeparator jSeparatorRunAgent1;
	private JButton jButtonSpawnAgent;
	private JFileChooser jFileChooser;
	
	private final String c_ABOUTMESSAGE =
		"RCSImitate Graphical User Interface v0.2 \n" +
		"Copyright 2008 Michael W. Floyd";
	private final String c_HELPLOG2CASEBASEMESSAGE = 
		"Log File: RoboCup log file generated by LogServer program \n" +
		"Case Base File: File to output the case base to \n" +
		"Team Name: The name of the team logged in the log file";

	
	/** Default constructor builds the GUI and makes the Frame ready
	 * to be displayed.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public RCSIFrame() {
		super();
		buildGUI();
	}
	
	/** Creates and lays out the components that make up the graphical
	 * user interface.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	private void buildGUI() {
		//give the frame a title
		this.setTitle("RCSImitate");
		
		//create the file chooser
		this.jFileChooser = new JFileChooser();
		
		//layout the GUI
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		{
			this.jTabbedPane = new JTabbedPane();
			getContentPane().add(this.jTabbedPane, BorderLayout.CENTER);
			{//this tab handles log2casebase conversion
				this.jPanelLog2CaseBase = new JPanel();
				this.jTabbedPane.addTab("Log2CaseBase", null, this.jPanelLog2CaseBase, null);
				this.jPanelLog2CaseBase.setLayout(null);
				{//add the button that begins the processing
					this.jButtonLog2CaseBase = new JButton();
					this.jPanelLog2CaseBase.add(this.jButtonLog2CaseBase);
					this.jButtonLog2CaseBase.setText("Log2CaseBase");
					this.jButtonLog2CaseBase.addActionListener(new ActionListener(){
						@SuppressWarnings("synthetic-access")
						public void actionPerformed(@SuppressWarnings("unused")
						ActionEvent e) {
							runLog2CaseBase();	
						}
					});
					this.jButtonLog2CaseBase.setLayout(null);
					this.jButtonLog2CaseBase.setBounds(106, 208, 141, 21);
				}
				{//add the text field where the log file name goes
					this.jInputFileName = new JTextField();
					this.jPanelLog2CaseBase.add(this.jInputFileName);
					this.jInputFileName.setText("Log File Name...");
					this.jInputFileName.setBounds(106, 23, 245, 21);
				}
				{//add the button that selects the log file to use
					this.jLogFileNameButton = new JButton();
					this.jPanelLog2CaseBase.add(this.jLogFileNameButton);
					this.jLogFileNameButton.setText("Select ...");
					this.jLogFileNameButton.addActionListener(new ActionListener(){
						@SuppressWarnings("synthetic-access")
						public void actionPerformed(@SuppressWarnings("unused")
						ActionEvent e) {
							selectLogFile();	
						}
					});
					this.jLogFileNameButton.setLayout(null);
					this.jLogFileNameButton.setBounds(12, 23, 83, 21);
				}
				{//add the button that selects the case base file to save to
					this.jCaseBaseFileNameButton = new JButton();
					this.jPanelLog2CaseBase.add(this.jCaseBaseFileNameButton);
					this.jCaseBaseFileNameButton.setText("Select ...");
					this.jCaseBaseFileNameButton.addActionListener(new ActionListener(){
						@SuppressWarnings("synthetic-access")
						public void actionPerformed(@SuppressWarnings("unused")
						ActionEvent e) {
							selectCaseBaseFile();	
						}
					});
					this.jCaseBaseFileNameButton.setLayout(null);
					this.jCaseBaseFileNameButton.setBounds(12, 79, 83, 21);
				}
				{//add the text field where the case base file name goes
					this.jOutputFileName = new JTextField();
					this.jPanelLog2CaseBase.add(this.jOutputFileName);
					this.jOutputFileName.setText("Case Base File Name...");
					this.jOutputFileName.setBounds(106, 79, 245, 21);
				}
				{//add the label for the team name text field
					this.jTeamName = new JTextField();
					this.jPanelLog2CaseBase.add(this.jTeamName);
					this.jTeamName.setText("Team Name...");
					this.jTeamName.setBounds(106, 133, 116, 21);
				}
				{//add the text field that contains the team name
					this.jLabelTeamName = new JLabel();
					this.jPanelLog2CaseBase.add(this.jLabelTeamName);
					this.jLabelTeamName.setText("Team Name:");
					this.jLabelTeamName.setBounds(12, 136, 82, 14);
				}
			}
			{//the tab for running the agent
				this.jPanelRunAgent = new JPanel();
				this.jTabbedPane.addTab("Run Agent", null, this.jPanelRunAgent, null);
				this.jPanelRunAgent.setLayout(null);
				{//team name label
					this.jLabelTeamName = new JLabel();
					this.jPanelRunAgent.add(this.jLabelTeamName);
					this.jLabelTeamName.setText("Team Name");
					this.jLabelTeamName.setBounds(102, 14, 68, 14);
				}
				{//the place to enter in the team anme
					this.jTextFieldTeamName = new JTextField();
					this.jPanelRunAgent.add(this.jTextFieldTeamName);
					this.jTextFieldTeamName.setText(RCSImitate.DEFAULT_TEAMNAME);
					this.jTextFieldTeamName.setBounds(170, 11, 134, 22);
				}
				{//the label for the server address
					this.jLabelServer = new JLabel();
					this.jPanelRunAgent.add(this.jLabelServer);
					this.jLabelServer.setText("Server");
					this.jLabelServer.setBounds(102, 37, 68, 14);
				}
				{//the place to enter the server address
					this.jTextFieldServer = new JTextField();
					this.jPanelRunAgent.add(this.jTextFieldServer);
					this.jTextFieldServer.setText(RCSImitate.DEFAULT_HOSTNAME);
					this.jTextFieldServer.setBounds(170, 33, 134, 23);
				}
				{//the place to enter the server port
					this.jTextFieldPort = new JTextField();
					this.jPanelRunAgent.add(this.jTextFieldPort);
					this.jTextFieldPort.setText(RCSImitate.DEFAULT_HOSTPORT + "");
					this.jTextFieldPort.setBounds(170, 56, 134, 23);
				}
				{//the label for the server port
					this.jLabelPort = new JLabel();
					this.jPanelRunAgent.add(this.jLabelPort);
					this.jLabelPort.setText("Port");
					this.jLabelPort.setBounds(103, 60, 68, 14);
				}
				{//the button that will spawn an agent
					this.jButtonSpawnAgent = new JButton();
					this.jPanelRunAgent.add(this.jButtonSpawnAgent);
					this.jButtonSpawnAgent.setText("Spawn Agent");
					this.jButtonSpawnAgent.setBounds(132, 265, 109, 21);
					this.jButtonSpawnAgent.addActionListener(new ActionListener(){
						@SuppressWarnings("synthetic-access")
						public void actionPerformed(@SuppressWarnings("unused")
						ActionEvent e) {
							spawnAgent();	
						}
					});
				}	
				{//seperates the items for readability
					this.jSeparatorRunAgent1 = new JSeparator();
					this.jPanelRunAgent.add(this.jSeparatorRunAgent1);
					this.jSeparatorRunAgent1.setBounds(58, 98, 298, 11);
				}
				{//button to select the file to use as the casebase
					this.jButtonCaseBaseFile = new JButton();
					this.jPanelRunAgent.add(this.jButtonCaseBaseFile);
					this.jButtonCaseBaseFile.setBounds(22, 137, 81, 23);
					this.jButtonCaseBaseFile.setText("Select...");
					//TODO add the action listener command
				}
				{//the field that holds what the case base file is
					this.jTextFieldCBFile = new JTextField();
					this.jPanelRunAgent.add(this.jTextFieldCBFile);
					this.jTextFieldCBFile.setBounds(132, 138, 224, 21);
					this.jTextFieldCBFile.setText(RCSImitate.DEFAULT_CASEBASEFILE);
				}
				{//a label so the user knows what to do
					this.jLabelCaseBaseFile = new JLabel();
					this.jPanelRunAgent.add(this.jLabelCaseBaseFile);
					this.jLabelCaseBaseFile.setText("Case Base File");
					this.jLabelCaseBaseFile.setBounds(138, 109, 122, 14);
				}
				{//another seperator for readability
					this.jSeparatorRunAgent2 = new JSeparator();
					this.jPanelRunAgent.add(this.jSeparatorRunAgent2);
					this.jSeparatorRunAgent2.setBounds(58, 182, 298, 11);
				}
				
			}
		}
		{//creates the menu bar
			this.jMenuBar = new JMenuBar();
			setJMenuBar(this.jMenuBar);
			{//adds the about menu
				this.jMenuAbout = new JMenu();
				this.jMenuBar.add(this.jMenuAbout);
				this.jMenuAbout.setText("About");
				{//adds the About menu item
					this.jMenuItemAbout = new JMenuItem();
					this.jMenuAbout.add(this.jMenuItemAbout);
					this.jMenuItemAbout.setText("About RCSImitate");
					this.jMenuItemAbout.addActionListener(new ActionListener(){
						@SuppressWarnings("synthetic-access")
						public void actionPerformed(@SuppressWarnings("unused")
						ActionEvent e) {
							displayAboutMessage();	
						}
					});
				}
			}
			{//adds the help menu
				this.jMenuHelp = new JMenu();
				this.jMenuBar.add(this.jMenuHelp);
				this.jMenuHelp.setText("Help");
				{//adds the LogFile2CaseBase help
					this.jMenuItemHelpLog2CaseBase = new JMenuItem();
					this.jMenuHelp.add(this.jMenuItemHelpLog2CaseBase);
					this.jMenuItemHelpLog2CaseBase.setText("LogFile2CaseBase");
					this.jMenuItemHelpLog2CaseBase.addActionListener(new ActionListener(){
						@SuppressWarnings("synthetic-access")
						public void actionPerformed(@SuppressWarnings("unused")
						ActionEvent e) {
							displayHelpLog2CaseBaseMessage();	
						}
					});
				}
				
			}
		}
		pack();
		this.setSize(400, 650);
	}
	
	/** Used to display the file open dialog so that a log file can be
	 * selected.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 * 
	 */
	private void selectLogFile(){
		int returnVal = this.jFileChooser.showOpenDialog(this);
		
		if(returnVal == JFileChooser.APPROVE_OPTION){
			String selectedFileName = this.jFileChooser.getSelectedFile().getAbsolutePath();
			this.jInputFileName.setText(selectedFileName);
		}
		
	}
	
	/** Used to display the file save dialog so that a case base file can be
	 * selected to output to.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 * 
	 */
	private void selectCaseBaseFile(){
		int returnVal = this.jFileChooser.showSaveDialog(this);
		
		if(returnVal == JFileChooser.APPROVE_OPTION){
			String selectedFileName = this.jFileChooser.getSelectedFile().getAbsolutePath();
			this.jOutputFileName.setText(selectedFileName);
		}
	}
	
	/** Used to run the Log2CaseBase program.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 * 
	 */
	private void runLog2CaseBase(){
		String input = this.jInputFileName.getText();
		String output = this.jOutputFileName.getText();
		String team = this.jTeamName.getText();
		try{
			LogFile2CaseBase builder = new LogFile2CaseBase(input, output, team);
			builder.parseLogFile();
			builder.writeCaseBaseFile();
			JOptionPane.showMessageDialog(this, "Case base written to " + output, "Complete", JOptionPane.INFORMATION_MESSAGE);
		}catch(Exception e){
			JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		}
	}
	
	/** Displays the desired message when user clicks "About" 
	 * menu item from the menu bar.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 * 
	 */
	private void displayAboutMessage(){
		JOptionPane.showMessageDialog(this, this.c_ABOUTMESSAGE, "About RCSImitate", JOptionPane.PLAIN_MESSAGE);
	}
	
	/** Displays the desired message when user clicks "Help"->"Log2CaseBase" 
	 * menu item from the menu bar.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 * 
	 */
	private void displayHelpLog2CaseBaseMessage(){
		JOptionPane.showMessageDialog(this, this.c_HELPLOG2CASEBASEMESSAGE, "Help", JOptionPane.PLAIN_MESSAGE);
	}
	
	/** Used to spawn a new agent, with the supplied parameters, when the
	 * appropriate button is pressed.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 *
	 */
	private void spawnAgent(){
		String serverName = this.jTextFieldServer.getText();
		String serverPort = this.jTextFieldPort.getText();
		String teamname = this.jTextFieldTeamName.getText();
		String cbFile = this.jTextFieldCBFile.getText();
		
		try{
			//TODO remove below
			CaseBase casebase = CaseBaseIO.loadCaseBase(cbFile);
			NoActionsFilter naf = new NoActionsFilter();
			casebase = naf.filter(casebase);
			CaseBaseSearch cbSearch = new NearestNeighbourSearch(1);
			
			SensoryItem.setDistanceCalculation(new EqualityDistanceAlgorithm());
			SensoryItem.setPenaltyDistanceCalculation(new ConstantPenalty(100));
			Spatial2DObject.setDistanceCalculation(new PolarDistanceAlgorithm());
			
			Weights w = new Weights(0.0f);
			w.setWeight(BallFeature.c_BALL, 1.0f);
			w.setWeight(TeammatePlayerFeature.c_TEAMMATE, 1.0f);
			GlobalDistanceMeasure gd = new OrderIndexMatchingAlgorithm(w);
			Case.setGlobalDistanceCalculation(gd);

			ActionEstimation ae = new LastActionEstimate();
			ActionSelection actionSelection = new ClosestNeighbourSelection(ae); 
		
			Agent ag = new Agent(casebase,cbSearch,actionSelection);
			//TODO remove above
			
			int port = (new Integer(serverPort)).intValue();
			RCSImitate newAgent = new RCSImitate(serverName, port, teamname, ag);
			(new Thread(newAgent)).start();
		}catch(Exception e){
			JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		}
	}

}
