/** OpponentPlayerFeature.java in the package org.RCSImitate.sensoryItems of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.RCSImitate.sensoryItems;

/** Represents an opponent player in RoboCup simulation soccer
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class OpponentPlayerFeature extends PlayerFeature {
	
	private static final long serialVersionUID = -106411452138256596L;
	
	public static String c_OPPONENT = "RoboCupSimulation.Opponent";
	
	/** Constructs an opponent player feature with the name
	 * of the feature as an opponent.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public OpponentPlayerFeature(){
		super(OpponentPlayerFeature.c_OPPONENT);
	}
}
