/** RoboCupSimulation2DSpatialObject.java in the package org.RCSImitate.sensoryItems of the RCSImitate project.
    Originally created 29-Jun-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.RCSImitate.sensoryItems;

import org.JIFSA.sensoryItems.Spatial2DObject;

/** Represents a spatial object that can be seen by a RoboCup simulation
 * agent. 
 * 
 * @author Michael W. Floyd
 * @since 0.2
 *
 */
public class RoboCupSimulation2DSpatialObject extends Spatial2DObject {

	private static final long serialVersionUID = 8192421539572833570L;
	
	//the change in distance since the last time point
	private float m_distanceChange;
	//the change in direction since the last time point
	private float m_directionChange;
	
	/** Creates an object with the given feature name.
	 * Distance changed, direction changed, distance and
	 * direction are all 0.
	 * 
	 * @param featureName The name of the feature.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public RoboCupSimulation2DSpatialObject(String featureName){
		super(featureName);
		//by default we assume the distance and direction are unchanged
		this.m_distanceChange = 0;
		this.m_directionChange = 0;
	}
	
	/** Set the distance changed
	 * 
	 * @param distChange The distance changed
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public void setDistanceChange(float distChange){
		this.m_distanceChange = distChange;
	}
	
	/** Set the direction changed.
	 *  
	 * @param dirChange The direction changed
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public void setDirectionChange(float dirChange){
		this.m_directionChange = dirChange;
	}
	
	/** Get the distance changed
	 * 
	 * @return The distance changed
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public float getDistanceChange(){
		return this.m_distanceChange;
	}
	
	/** Get the direction changed
	 * 
	 * @return
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public float getDirectionChange(){
		return this.m_directionChange;
	}
	
	/** Overrides the equals method
	 * 
	 */
	@Override
	public boolean equals(Object o){
		//check for same object
		if(this == o){
			return true;
		}
		
		//check for null or other class
		if(o == null || !(o instanceof RoboCupSimulation2DSpatialObject)){
			return false;
		}
		
		//typecast
		RoboCupSimulation2DSpatialObject rcf = (RoboCupSimulation2DSpatialObject)o;
		
		//check super class attributes
		if(!super.equals(rcf)){
			return false;
		}
		
		return ( (this.m_directionChange == rcf.getDirectionChange()) && (this.m_distanceChange == rcf.getDistanceChange()) );
	}
}
