/** UnknownPlayerFeature.java in the package org.RCSImitate.sensoryItems of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.RCSImitate.sensoryItems;

/** Represents a player of an unknown team in RoboCup Simulation soccer
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class UnknownPlayerFeature extends PlayerFeature{
	
	private static final long serialVersionUID = -3924380833818507991L;
	
	public static String c_UNKNOWNPLAYER = "RoboCupSimulation.UnknownPlayer";
	
	/** Constructs an unknown player feature
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public UnknownPlayerFeature(){
		super(UnknownPlayerFeature.c_UNKNOWNPLAYER);
	}
}
