/** DashAction.java in the package org.RCSImitate.soccersimactions of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.RCSImitate.soccersimactions;


import org.JIFSA.AgentAction;

/** Represents the action of dashing, one of the possible actions
 * a RoboCup Simulation agent can perform.
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class DashAction extends AgentAction {

	private static final long serialVersionUID = 17057566588969512L;

	//the name of the action
	public static String c_DASH = "RoboCupSimulationSoccer.DASH";

	//the power of the dash
	private float m_power;
	
	/** The default constructor for the DashAction class. Sets
	 * the action name to DashAction.c_DASH and the power to zero.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public DashAction(){
		super(DashAction.c_DASH);
		this.m_power = 0.0f;
	}
	
	/** Constructor for the DashAction class. Sets the
	 * action name to DashAction.c_DASH and the power
	 * to the supplied value.
	 * 
	 * @param power The dash power
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public DashAction(float power){
		super(DashAction.c_DASH);
		this.m_power = power;
	}
	
	/** Returns the power of the dash.
	 * 
	 * @return The power of the dash
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public float getDashPower(){
		return this.m_power;
	}
	
	/** Overrides the equals method
	 * 
	 */
	@Override
	public boolean equals(Object o){
		//see if this is the object
		if(this == o){
			return true;
		}
		
		//test for null or other class type
		if(o == null || !(o instanceof DashAction)){
			return false;
		}
		
		//typecase object
		DashAction da = (DashAction)o;
		
		if(!super.equals(da)){
			return false;
		}
		
		return (this.m_power == da.getDashPower());
	}
	
}
