/** KickAction.java in the package org.RCSImitate.soccersimactions of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.RCSImitate.soccersimactions;

import org.JIFSA.AgentAction;

/** Represents the action of kicking, one of the possible actions
 * a RoboCup agent can perform.
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class KickAction extends AgentAction {

	private static final long serialVersionUID = 4124279140699703775L;

	//the name of the action
	public static String c_KICK = "RoboCupSimulationSoccer.KICK";

	//the power of the kick
	private float m_power;
	
	//the angle of the kick
	private float m_angle;
	
	/** The default constructor for the KickAction class. Sets
	 * the action name to KickAction.c_KICK and the power to zero.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public KickAction(){
		super(KickAction.c_KICK);
		this.m_power = 0.0f;
		this.m_angle = 0.0f;
	}
	
	/** Constructor for the KickAction class. Sets the
	 * action name to KickAction.c_KICK and the power/angle
	 * to the supplied values.
	 * 
	 * @param power The kick power
	 * @param angle The kick angle
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public KickAction(float power,float angle){
		super(KickAction.c_KICK);
		this.m_power = power;
		this.m_angle = angle;
	}
	
	/** Returns the power of the kick.
	 * 
	 * @return The power of the kick
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public float getKickPower(){
		return this.m_power;
	}
	
	/** Returns the angle of the kick.
	 * 
	 * @return The angle of the kick
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public float getKickAngle(){
		return this.m_angle;
	}
	
	/** Override the equals method
	 * 
	 */
	@Override
	public boolean equals(Object o){
		//see if this is the object
		if(this == o){
			return true;
		}
		
		//test for null or other class type
		if(o == null || !(o instanceof KickAction)){
			return false;
		}
		
		//typecast the object
		KickAction ka = (KickAction)o;
		
		//make sure they have the same super class features
		if(!super.equals(ka)){
			return false;
		}
		
		return ( (this.m_angle == ka.getKickAngle()) && (this.m_power) == ka.getKickPower() );
	}
}
