/** TurnAction.java in the package org.RCSImitate.occersimactions of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.RCSImitate.soccersimactions;


import org.JIFSA.AgentAction;

/** Represents the action of turning, one of the possible actions
 * a RoboCup Simulation agent can perform.
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class TurnAction extends AgentAction {

	private static final long serialVersionUID = 5171388549910183996L;

	//the name of the action
	public static String c_TURN = "RoboCupSimulationSoccer.TURN";

	//the angle of the turn
	private float m_angle;
	
	/** The default constructor for the TurnAction class. Sets
	 * the action name to TurnAction.c_TURN and the angle to zero.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public TurnAction(){
		super(TurnAction.c_TURN);
		this.m_angle = 0.0f;
	}
	
	/** Constructor for the TurnAction class. Sets the
	 * action name to TurnAction.c_TURN and the angle
	 * to the supplied value.
	 * 
	 * @param angle The turn angle
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public TurnAction(float angle){
		super(TurnAction.c_TURN);
		this.m_angle = angle;
	}
	
	/** Returns the angle of the turn.
	 * 
	 * @return The angle of the turn
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public float getTurnAngle(){
		return this.m_angle;
	}
	
	/** Overrides equals method
	 * 
	 */
	@Override
	public boolean equals(Object o){
		//see if this is the object
		if(this == o){
			return true;
		}
		
		//test for null or other class type
		if(o == null || !(o instanceof TurnAction)){
			return false;
		}
		
		//typecast it as a TurnAction
		TurnAction ta = (TurnAction)o;
		
		//compare features of the super class
		if(!super.equals(ta)){
			return false;
		}
		
		return (this.m_angle == ta.getTurnAngle());
	}
}
