/** TurnNeckAction.java in the package org.RCSImitate.soccersimactions of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.RCSImitate.soccersimactions;


import org.JIFSA.AgentAction;

/** Represents the action of turning the neck, one of the possible actions
 * a RoboCup Simulation agent can perform.
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class TurnNeckAction extends AgentAction {

	private static final long serialVersionUID = 9021163542632369731L;

	//the name of the action
	public static String c_TURNNECK = "RoboCupSimulationSoccer.TURN_NECK";

	//the angle of the neck turn
	private float m_angle;
	
	/** The default constructor for the TurnNeckAction class. Sets
	 * the action name to TurnNeckAction.c_TURNNECK and the angle to zero.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public TurnNeckAction(){
		super(TurnNeckAction.c_TURNNECK);
		this.m_angle = 0.0f;
	}
	
	/** Constructor for the TurnNeckAction class. Sets the
	 * action name to TurnNeckAction.c_TURNNECK and the angle
	 * to the supplied value.
	 * 
	 * @param angle The neck turn angle
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public TurnNeckAction(float angle){
		super(TurnNeckAction.c_TURNNECK);
		this.m_angle = angle;
	}
	
	/** Returns the angle of the neck turn.
	 * 
	 * @return The angle of the turn
	 *
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	public float getTurnNeckAngle(){
		return this.m_angle;
	}
	
	/** Override the equals method
	 * 
	 */
	@Override
	public boolean equals(Object o){
		//see if this is the object
		if(this == o){
			return true;
		}
		
		//test for null or other class type
		if(o == null || !(o instanceof TurnNeckAction)){
			return false;
		}
		
		//typecast the object
		TurnNeckAction tna = (TurnNeckAction)o;
		
		//check the super class attributes
		if(!super.equals(tna)){
			return false;
		}
		
		return (this.m_angle == tna.getTurnNeckAngle());
	}
}
