/** BallFeatureTest.java in the package tests.junit.org.RCSImitate.sensoryItems of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.RCSImitate.sensoryItems;

import static org.junit.Assert.assertEquals;

import org.RCSImitate.sensoryItems.BallFeature;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/** Tests for the org.RCSImitate.sensoryItems.BallFeature class
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class BallFeatureTest {

	/** Makes sure the default constructor sets the name
	 * of the feature properly.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void constructor_name(){
		BallFeature bf = new BallFeature();
		assertEquals(bf.getFeatureName(),BallFeature.c_BALL);
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(BallFeatureTest.class);
	}
}
