/** GoalFeatureTest.java in the package tests.junit.org.RCSImitate.sensoryItems of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.RCSImitate.sensoryItems;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.RCSImitate.sensoryItems.GoalFeature;
import org.junit.Test;

/** Tests for the org.RCSImitate.sensoryItems.GoalFeature class
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class GoalFeatureTest {
	
	/** Tests that the constructor sets the feature name
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void constructor_name(){
		GoalFeature gf = new GoalFeature();
		assertEquals(gf.getFeatureName(), GoalFeature.c_GOAL);
	}
	
	/** Test to see the the side is set to unknown in the
	 * default constructor
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test 
	public void constructor_default(){
		GoalFeature gf = new GoalFeature();
		assertEquals(gf.getSide(), GoalFeature.c_SIDE_UNKNOWN);
	}
	
	/** Tests that an object can be set to the left side
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void constructor_sideL(){
		GoalFeature gf = new GoalFeature();
		gf.setSide(GoalFeature.c_SIDE_LEFT);
		assertEquals(gf.getSide(), GoalFeature.c_SIDE_LEFT);
	}
	
	/** Tests that an object can be set to the right side
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void constructor_sideR(){
		GoalFeature gf = new GoalFeature();
		gf.setSide(GoalFeature.c_SIDE_RIGHT);
		assertEquals(gf.getSide(), GoalFeature.c_SIDE_RIGHT);
	}
	
	/** Tests giving an invalid side
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test(expected=IllegalArgumentException.class)
	public void setSide_invalidSide(){
		GoalFeature gf = new GoalFeature();
		gf.setSide("c");
	}
	
	/** Tests giving a null side
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test(expected=IllegalArgumentException.class)
	public void setSide_nullSide(){
		GoalFeature gf = new GoalFeature();
		gf.setSide(null);
	}
	
	/** Tests equals with a null parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_null(){
		GoalFeature gf = new GoalFeature();
		assertFalse(gf.equals(null));
	}
	
	/** Tests equals with a different class type
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentClass(){
		GoalFeature gf = new GoalFeature();
		String s = new String();
		assertFalse(gf.equals(s));
	}
	
	/** Tests equals when the objects are same
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_same(){
		GoalFeature gf1 = new GoalFeature();
		gf1.setSide(GoalFeature.c_SIDE_RIGHT);
		GoalFeature gf2 = new GoalFeature();
		gf2.setSide(GoalFeature.c_SIDE_RIGHT);
		
		GoalFeature gf3 = new GoalFeature();
		gf3.setSide(GoalFeature.c_SIDE_LEFT);
		GoalFeature gf4 = new GoalFeature();
		gf4.setSide(GoalFeature.c_SIDE_LEFT);
		
		assertEquals(gf1,gf2);
		assertEquals(gf3,gf4);
	}
	
	
	/** Tests equals when the objects are different
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_different(){
		GoalFeature gf1 = new GoalFeature();
		gf1.setSide(GoalFeature.c_SIDE_RIGHT);
		GoalFeature gf2 = new GoalFeature();
		gf2.setSide(GoalFeature.c_SIDE_LEFT);
		
		assertFalse(gf1.equals(gf2));
	}
	
	/** Tests equals to self
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_self(){
		GoalFeature gf = new GoalFeature();
		assertTrue(gf.equals(gf));
	}
	
	/** Tests equals when Goal variables are the same
	 * but superclass variables are different
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_superDifferent(){
		GoalFeature gf1 = new GoalFeature();
		GoalFeature gf2 = new GoalFeature();
		gf2.setDirectionChange(1.1f);
		gf2.setDistanceChange(99f);
		assertFalse(gf1.equals(gf2));
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(GoalFeatureTest.class);
	}
}
