/** RoboCupSimulation2DSpatialObject.java in the package tests.junit.org.RCSImitate.sensoryItems of the RCSImitate project.
    Originally created 7-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package tests.junit.org.RCSImitate.sensoryItems;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.RCSImitate.sensoryItems.RoboCupSimulation2DSpatialObject;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/** Tests for the org.RCSImitate.sensoryItems.RoboCupSimulation2DSpatialObject class
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class RoboCupSimulation2DSpatialObjectTest {

	/** Test the constructor with a null parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test(expected=IllegalArgumentException.class)
	public void constructor_nullName(){
		new RoboCupSimulation2DSpatialObject(null);
	}
	
	/** Test to see if the default values are set for
	 * distanceChange and directionChange
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void constructor_default(){
		RoboCupSimulation2DSpatialObject rcf = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		assertEquals(rcf.getDistanceChange(),0.0f);
		assertEquals(rcf.getDistanceChange(),0.0f);
	}
	
	/** Makes sure the name is properly set by constructor
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void constructor_nameSet(){
		RoboCupSimulation2DSpatialObject rcf = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		assertEquals(rcf.getFeatureName(),"RoboCupFeature");
	}
	
	/** Make sure the direction change can be set.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void setDirectionChange(){
		RoboCupSimulation2DSpatialObject rcf = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf.setDirectionChange(3.5f);
		assertEquals(rcf.getDirectionChange(),3.5f);
	}
	
	/** Make sure the distanace change can be set.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void setDistanceChange(){
		RoboCupSimulation2DSpatialObject rcf = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf.setDistanceChange(105.66f);
		assertEquals(rcf.getDistanceChange(),105.66f);
	}
	
	/** Tests equality given a null parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_null(){
		RoboCupSimulation2DSpatialObject rcf = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		assertFalse(rcf.equals(null));
	}
	
	/** Tests equality with a different class type
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentClass(){
		RoboCupSimulation2DSpatialObject rcf = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		String s = new String();
		assertFalse(rcf.equals(s));
	}
	
	/** Tests the equality of two same objects created with the
	 * default constructor.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_default(){
		RoboCupSimulation2DSpatialObject rcf1 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		RoboCupSimulation2DSpatialObject rcf2 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		assertEquals(rcf1,rcf2);
	}
	
	/** Tests the equality of two same objects created with the
	 * default constructor and then modified.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_notDefault(){
		RoboCupSimulation2DSpatialObject rcf1 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf1.setDirectionChange(12.1f);
		rcf1.setDistanceChange(74.1f);
		RoboCupSimulation2DSpatialObject rcf2 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf2.setDirectionChange(12.1f);
		rcf2.setDistanceChange(74.1f);
		assertEquals(rcf1,rcf2);
	}
	
	/** Tests the equality of two objects with a different name.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentName(){
		RoboCupSimulation2DSpatialObject rcf1 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf1.setDirectionChange(12.1f);
		rcf1.setDistanceChange(74.1f);
		RoboCupSimulation2DSpatialObject rcf2 = new RoboCupSimulation2DSpatialObject("otherFeature");
		rcf2.setDirectionChange(12.1f);
		rcf2.setDistanceChange(74.1f);
		assertFalse(rcf1.equals(rcf2));
	}
	
	/** Tests the equality of two objects with a different direction change.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentDirectionChange(){
		RoboCupSimulation2DSpatialObject rcf1 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf1.setDirectionChange(0.1f);
		rcf1.setDistanceChange(74.1f);
		RoboCupSimulation2DSpatialObject rcf2 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf2.setDirectionChange(12.1f);
		rcf2.setDistanceChange(74.1f);
		assertFalse(rcf1.equals(rcf2));
	}
	
	/** Tests the equality of two objects with a different distance change.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentDistanceChange(){
		RoboCupSimulation2DSpatialObject rcf1 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf1.setDirectionChange(12.1f);
		rcf1.setDistanceChange(3.33f);
		RoboCupSimulation2DSpatialObject rcf2 = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		rcf2.setDirectionChange(12.1f);
		rcf2.setDistanceChange(74.1f);
		assertFalse(rcf1.equals(rcf2));
	}
	
	/** Makes sure an object equals itself
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_self(){
		RoboCupSimulation2DSpatialObject rcf = new RoboCupSimulation2DSpatialObject("RoboCupFeature");
		assertTrue(rcf.equals(rcf));
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(RoboCupSimulation2DSpatialObjectTest.class);
	}
	
}
