/** TeammatePlayerFeatureTest.java in the package tests.junit.org.RCSImitate.sensoryItems of the RCSImitate project.
    Originally created 10-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.RCSImitate.sensoryItems;

import static org.junit.Assert.assertEquals;
import junit.framework.JUnit4TestAdapter;

import org.RCSImitate.sensoryItems.TeammatePlayerFeature;
import org.junit.Test;

/** Tests the org.RCSImitate.sensoryItems.TeammatePlayerFeature class
 * 
 * @author Michael W. Floyd
 * @since 0.2
 */
public class TeammatePlayerFeatureTest {

	/** Make sure the feature name is properly set by
	 * the constructor.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void constructor_name(){
		TeammatePlayerFeature tf = new TeammatePlayerFeature();
		assertEquals(tf.getFeatureName(),TeammatePlayerFeature.c_TEAMMATE);
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(TeammatePlayerFeatureTest.class);
	}
}
