/** DashActionTest.java in the package tests.junit.org.RCSImitate.occersimactions of the RCSImitate project.
    Originally created 8-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.RCSImitate.soccersimactions;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.RCSImitate.soccersimactions.DashAction;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/** Tests for the org.RCSImitate.soccersimactions.DashAction class
 * 
 * @author Michael W. Floyd
 * @since 0.2 
 */
public class DashActionTest {

	/** Tests the default constructor
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void defaultConstructor(){
		DashAction da = new DashAction();
		assertTrue(da.getActionName().equals(DashAction.c_DASH));
		assertEquals(da.getDashPower(),0.0f);
	}
	
	/** Tests the constructor with power as a parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void powerConstructor(){
		DashAction da = new DashAction(9.8f);
		assertTrue(da.getActionName().equals(DashAction.c_DASH));
		assertEquals(da.getDashPower(),9.8f);
	}
	
	/** Tests to see if the DashAction is
	 * found to be equal to null
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_null(){
		DashAction da = new DashAction();
		assertFalse(da.equals(null));
	}
	
	/** Tests to see if the DashAction is
	 * found to be equal to a different Object class
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test 
	public void equals_differntClass(){
		DashAction da = new DashAction();
		String s = new String();
		assertFalse(da.equals(s));
	}
	
	/** Make sure two default DashActions
	 * are equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equalDefault(){
		DashAction da1 = new DashAction();
		DashAction da2 = new DashAction();
		assertEquals(da1,da2);
	}
	
	/** Make sure two DashActions with same parameters
	 * are equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equal(){
		DashAction da1 = new DashAction(9.8f);
		DashAction da2 = new DashAction(9.8f);
		assertEquals(da1,da2);
	}
	
	/** Make sure two DashActions with different parameters
	 * are not equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_unequal(){
		DashAction da1 = new DashAction(12.2f);
		DashAction da2 = new DashAction(1.5f);
		assertFalse(da1.equals(da2));
	}
	
	/** Make sure a DashAction is equal to itself
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_self(){
		DashAction da = new DashAction(12.2f);
		assertTrue(da.equals(da));
	}
	
	/** Make sure a DashAction is not equal to another
	 * dash action with the same parameters if it has a
	 * different action name
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentNameSameType(){
		DashAction da = new DashAction(12.2f);
		
		//change the name of a dash
		DashAction.c_DASH = "NOT_DASH";
		DashAction da2 = new DashAction(12.2f);
		
		assertFalse(da.equals(da2));
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(DashActionTest.class);
	}
}
