/** KickActionTest.java in the package tests.junit.org.RCSImitate.soccersimactions of the RCSImitate project.
    Originally created 8-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.RCSImitate.soccersimactions;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.RCSImitate.soccersimactions.KickAction;
import org.junit.Test;

/** Tests for the org.RCSImitate.soccersimactions.KickAction class
 * 
 * @author Michael W. Floyd
 * @since 0.2 
 */
public class KickActionTest {

	/** Tests the default constructor
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void defaultConstructor(){
		KickAction ka = new KickAction();
		assertTrue(ka.getActionName().equals(KickAction.c_KICK));
		assertEquals(ka.getKickPower(),0.0f);
		assertEquals(ka.getKickAngle(),0.0f);
	}
	
	/** Tests the constructor with power/angle as a parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void powerangleConstructor(){
		KickAction ka = new KickAction(12.1f, 0.1f);
		assertTrue(ka.getActionName().equals(KickAction.c_KICK));
		assertEquals(ka.getKickPower(),12.1f);
		assertEquals(ka.getKickAngle(),0.1f);
	}
	
	/** Makes sure a null value is not
	 * considered equal.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_null(){
		KickAction ka = new KickAction();
		assertFalse(ka.equals(null));
	}
	
	/** Makes sure a different class object
	 * is not considered equal.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test 
	public void equals_differntClass(){
		KickAction ka = new KickAction();
		String s = new String();
		assertFalse(ka.equals(s));
	}
	
	/** Makes sure equal objects are considered equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equal(){
		KickAction ka1 = new KickAction(0.7f,55.2f);
		KickAction ka2 = new KickAction(0.7f,55.2f);
		assertEquals(ka1,ka2);
	}
	
	/** Makes sure objects made with the default
	 * constructor are found to be equal.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equalDefault(){
		KickAction ka1 = new KickAction();
		KickAction ka2 = new KickAction();
		assertEquals(ka1,ka2);
	}
	
	/** Tests when the powers are the
	 * same but angles are different.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equalPowerUnequalAngle(){
		KickAction ka1 = new KickAction(0.7f,55.2f);
		KickAction ka2 = new KickAction(0.7f,9.2f);
		assertFalse(ka1.equals(ka2));
	}
	
	/** Tests when the powers are different
	 * but angles are same.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equalAngleUnequalPower(){
		KickAction ka1 = new KickAction(0.7f,55.2f);
		KickAction ka2 = new KickAction(44.0f,55.2f);
		assertFalse(ka1.equals(ka2));
	}
	
	/** Tests when both params are unequal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_unequalBoth(){
		KickAction ka1 = new KickAction(0.7f,55.2f);
		KickAction ka2 = new KickAction(44.0f,19.4f);
		assertFalse(ka1.equals(ka2));
	}
	
	/** Make sure a KickAction is equal to itself
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_self(){
		KickAction ka = new KickAction(12.2f,9.2f);
		assertTrue(ka.equals(ka));
	}
	
	/** Make sure a KickAction is not equal to another
	 * dash action with the same parameters if it has a
	 * different action name
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentNameSameType(){
		KickAction ka = new KickAction(12.2f,9.2f);
		
		//change the name of a dash
		KickAction.c_KICK = "NOT_KICK";
		KickAction ka2 = new KickAction(12.2f,9.2f);
		
		assertFalse(ka.equals(ka2));
	}
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(KickActionTest.class);
	}
}
