/** TurnActionTest.java in the package tests.junit.org.RCSImitate.soccersimactions of the RCSImitate project.
    Originally created 8-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.RCSImitate.soccersimactions;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.RCSImitate.soccersimactions.TurnAction;
import org.junit.Test;

/** Tests for the org.RCSImitate.soccersimactions.TurnAction class
 * 
 * @author Michael W. Floyd
 * @since 0.2 
 */
public class TurnActionTest {

	/** Tests the default constructor
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void defaultConstructor(){
		TurnAction ta = new TurnAction();
		assertTrue(ta.getActionName().equals(TurnAction.c_TURN));
		assertEquals(ta.getTurnAngle(),0.0f);
	}
	
	/** Tests the constructor with angle as a parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void angleConstructor(){
		TurnAction ta = new TurnAction(2.7f);
		assertTrue(ta.getActionName().equals(TurnAction.c_TURN));
		assertEquals(ta.getTurnAngle(),2.7f);
	}
	
	/** Tests equals given a null value
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_null(){
		TurnAction ta = new TurnAction();
		assertFalse(ta.equals(null));
	}
	
	/** Tests equals given a different type of
	 * object
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test 
	public void equals_differntClass(){
		TurnAction ta = new TurnAction();
		String s = new String();
		assertFalse(ta.equals(s));
	}
	
	/** Tests two equal objects
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equal(){
		TurnAction ta1 = new TurnAction(12.5f);
		TurnAction ta2 = new TurnAction(12.5f);
		assertEquals(ta1,ta2);
	}
	
	/** Tests if two default constructed
	 * objects are equal.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equalDefault(){
		TurnAction ta1 = new TurnAction();
		TurnAction ta2 = new TurnAction();
		assertEquals(ta1,ta2);
	}
	
	/** Tests two unequal objects.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_unequal(){
		TurnAction ta1 = new TurnAction(12.5f);
		TurnAction ta2 = new TurnAction(0.23f);
		assertFalse(ta1.equals(ta2));
	}
	
	/** Make sure a TurnAction is equal to itself
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_self(){
		TurnAction ta = new TurnAction(12.2f);
		assertTrue(ta.equals(ta));
	}
	
	/** Make sure a TurnAction is not equal to another
	 * dash action with the same parameters if it has a
	 * different action name
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentNameSameType(){
		TurnAction ta = new TurnAction(12.2f);
		
		//change the name of a turn
		TurnAction.c_TURN = "NOT_TURN";
		TurnAction ta2 = new TurnAction(12.2f);
		
		assertFalse(ta.equals(ta2));
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(TurnActionTest.class);
	}
}
