/** TurnNeckActionTest.java in the package tests.junit.org.RCSImitate.soccersimactions of the RCSImitate project.
    Originally created 8-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package tests.junit.org.RCSImitate.soccersimactions;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.RCSImitate.soccersimactions.TurnNeckAction;
import org.junit.Test;

/** Tests for the org.RCSImitate.soccersimactions.TurnNeckAction class
 * 
 * @author Michael W. Floyd
 * @since 0.2 
 */
public class TurnNeckActionTest {

	/** Tests the default constructor
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void defaultConstructor(){
		TurnNeckAction tna = new TurnNeckAction();
		assertTrue(tna.getActionName().equals(TurnNeckAction.c_TURNNECK));
		assertEquals(tna.getTurnNeckAngle(),0.0f);
	}
	
	/** Tests the constructor with angle as a parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void angleConstructor(){
		TurnNeckAction tna = new TurnNeckAction(99.3f);
		assertTrue(tna.getActionName().equals(TurnNeckAction.c_TURNNECK));
		assertEquals(tna.getTurnNeckAngle(),99.3f);
	}
	
	/** Test equals with a null parameter
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_null(){
		TurnNeckAction tna = new TurnNeckAction();
		assertFalse(tna.equals(null));
	}
	
	/** Test equals with a different type of object
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test 
	public void equals_differntClass(){
		TurnNeckAction tna = new TurnNeckAction();
		String s = new String();
		assertFalse(tna.equals(s));
	}
	
	/** Test if two same objects are equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equal(){
		TurnNeckAction tna1 = new TurnNeckAction(42.6f);
		TurnNeckAction tna2 = new TurnNeckAction(42.6f);
		assertEquals(tna1,tna2);
	}
	
	/** Test if two objects made with the default
	 * constructor are equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_equalDefault(){
		TurnNeckAction tna1 = new TurnNeckAction();
		TurnNeckAction tna2 = new TurnNeckAction();
		assertEquals(tna1,tna2);
	}
	
	/** Test if two different objects are equal
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_unequal(){
		TurnNeckAction tna1 = new TurnNeckAction(0.00f);
		TurnNeckAction tna2 = new TurnNeckAction(9.4f);
		assertFalse(tna1.equals(tna2));
	}
	
	/** Make sure a TurnNeckAction is equal to itself
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_self(){
		TurnNeckAction tna = new TurnNeckAction(12.2f);
		assertTrue(tna.equals(tna));
	}
	
	/** Make sure a TurnNeckAction is not equal to another
	 * dash action with the same parameters if it has a
	 * different action name
	 * 
	 * @author Michael W. Floyd
	 * @since 0.2
	 */
	@Test
	public void equals_differentNameSameType(){
		TurnNeckAction tna = new TurnNeckAction(12.2f);
		
		//change the name of a turn
		TurnNeckAction.c_TURNNECK = "NOT_TURNNECK";
		TurnNeckAction tna2 = new TurnNeckAction(12.2f);
		
		assertFalse(tna.equals(tna2));
	}
	
	public static junit.framework.Test suite(){
		return new JUnit4TestAdapter(TurnNeckActionTest.class);
	}
}
