/*
 * Decompiled with CFR 0.152.
 */
package org.RCSLogServer;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;
import org.RCSLogServer.LogMemory;

class ClientServerComm
extends Thread {
    private DatagramSocket listen_socket;
    private LogMemory log_memory;
    private boolean stopthread = false;

    public ClientServerComm(DatagramSocket datagramSocket, LogMemory logMemory) {
        this.listen_socket = datagramSocket;
        this.log_memory = logMemory;
        this.start();
    }

    public void finalize() {
    }

    public synchronized void initiateStop() {
        this.stopthread = true;
    }

    public synchronized boolean stopThread() {
        return this.stopthread;
    }

    @Override
    public void run() {
        byte[] byArray = new byte[this.log_memory.getPacketSize()];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, this.log_memory.getPacketSize());
        try {
            this.listen_socket.receive(datagramPacket);
        }
        catch (IOException iOException) {
            System.err.println("Socket receiving error " + iOException);
        }
        String string = new String(byArray).trim();
        this.log_memory.setClientHost(datagramPacket.getAddress());
        this.log_memory.setClientPort(datagramPacket.getPort());
        this.log_memory.parseClientInit(string);
        this.send(string);
        while (!this.stopThread()) {
            string = this.receive();
            this.send(string);
            this.log_memory.log.addRecord(string);
        }
    }

    private void send(String string) {
        byte[] byArray = new byte[this.log_memory.getPacketSize()];
        byArray = Arrays.copyOf(string.getBytes(), this.log_memory.getPacketSize());
        DatagramPacket datagramPacket = new DatagramPacket(byArray, this.log_memory.getPacketSize(), this.log_memory.server_host, this.log_memory.server_port);
        try {
            this.log_memory.server_socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            System.err.println("Socket sending error " + iOException);
        }
    }

    private String receive() {
        byte[] byArray = new byte[this.log_memory.getPacketSize()];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, this.log_memory.getPacketSize());
        try {
            this.log_memory.client_socket.receive(datagramPacket);
        }
        catch (IOException iOException) {
            System.err.println("Socket receiving error " + iOException);
        }
        return new String(byArray).trim();
    }
}

