/*
 * Decompiled with CFR 0.152.
 */
package org.RCSLogServer;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.RCSLogServer.Logger;

class LogMemory {
    public InetAddress server_host;
    public InetAddress client_host;
    public int server_port = 0;
    public int client_port = 0;
    public DatagramSocket server_socket;
    public DatagramSocket client_socket;
    public Logger log;
    private String logfile;
    private String playername;
    private String teamname;
    private String playernum;
    private String clientInitString;
    private String serverInitString;
    private int packet_size;
    private static Pattern init_pattern = Pattern.compile("^\\(init\\s+(\\w+)\\s*(.*)\\)$");

    public LogMemory(InetAddress inetAddress, int n) {
        this.server_host = inetAddress;
        this.server_port = n;
        this.playername = "";
        this.teamname = "";
        this.playernum = "";
        this.logfile = "";
        this.client_port = 0;
        this.client_host = null;
        this.log = null;
        this.packet_size = 4096;
        try {
            this.server_socket = new DatagramSocket();
            this.client_socket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            System.err.println("Unable to create sockets for communication: " + socketException);
            System.exit(0);
        }
    }

    public void finalize() {
    }

    public synchronized boolean checkClient() {
        return this.client_port > 0;
    }

    public synchronized void setClientPort(int n) {
        this.client_port = n;
    }

    public synchronized void setClientHost(InetAddress inetAddress) {
        this.client_host = inetAddress;
    }

    public synchronized int getClientPort() {
        return this.client_port;
    }

    public synchronized InetAddress getClientHost() {
        return this.client_host;
    }

    public synchronized boolean checkServer() {
        return this.server_port != 6000;
    }

    public synchronized void setServerPort(int n) {
        this.server_port = n;
    }

    public synchronized void setServerHost(InetAddress inetAddress) {
        this.server_host = inetAddress;
    }

    public synchronized int getServerPort() {
        return this.server_port;
    }

    public synchronized InetAddress getServerHost() {
        return this.server_host;
    }

    public synchronized void setPlayerNumber(String string) {
        this.playernum = string;
        this.playername = this.teamname + "_" + this.playernum;
        this.createOutputFile();
    }

    public synchronized void setTeamname(String string) {
        this.teamname = string;
        this.playername = this.teamname + "_" + this.playernum;
        this.createOutputFile();
    }

    public synchronized String getPlayerName() {
        return this.playername;
    }

    public synchronized int getPacketSize() {
        return this.packet_size;
    }

    public synchronized void setPacketSize(int n) {
        this.packet_size = n;
    }

    public synchronized void parseClientInit(String string) {
        double d = 3.0;
        Matcher matcher = init_pattern.matcher(string);
        if (matcher.matches()) {
            this.clientInitString = string;
            this.setTeamname(matcher.group(1));
            if (matcher.groupCount() > 1) {
                Pattern pattern = Pattern.compile("\\(version\\s+([\\w\\.]+)\\)");
                Matcher matcher2 = pattern.matcher(matcher.group(2));
                if (matcher2.find()) {
                    d = Double.parseDouble(matcher2.group(1));
                }
                if (d >= 6.0) {
                    this.setPacketSize(4096);
                } else {
                    this.setPacketSize(1024);
                }
            }
        }
    }

    public synchronized void parseServerInit(String string) {
        Matcher matcher = init_pattern.matcher(string);
        if (matcher.matches()) {
            Pattern pattern;
            Matcher matcher2;
            this.serverInitString = string;
            if (matcher.groupCount() > 1 && (matcher2 = (pattern = Pattern.compile("^\\s*(\\w+?)\\s+.*$")).matcher(matcher.group(2))).matches()) {
                this.setPlayerNumber(matcher2.group(1));
            }
        }
    }

    public String getFilename() {
        return this.logfile;
    }

    private void createOutputFile() {
        if (this.teamname.compareTo("") != 0 && this.playernum.compareTo("") != 0 && this.log == null) {
            this.logfile = this.playername + ".lsf";
            this.log = new Logger(this.logfile);
            this.log.addRecord(this.clientInitString);
            this.log.addRecord(this.serverInitString);
        }
    }
}

