/*
 * Decompiled with CFR 0.152.
 */
package org.RCSLogServer.LogParser;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.RCSLogServer.LogParser.ParsedLine;
import org.RCSLogServer.LogParser.ParsingEvent;
import org.RCSLogServer.LogParser.ParsingEventListener;

public class LogParser {
    private ParsedLine parsed = new ParsedLine();
    private int cycle = -1;
    private ArrayList<ParsingEventListener> PEListeners = new ArrayList();
    private String lastType = "sensor";
    public static Pattern controls = Pattern.compile("^(?:dash|kick|turn|move|catch|say|change_view|turn_neck|attentionto|ear|clang|change_player_type)$");
    public static Pattern simple_controls = Pattern.compile("^(?:sense_body|score|bye)$");
    public static Pattern sensors = Pattern.compile("^(?:hear|see|sense_body|score|ok)$");
    public static Pattern init = Pattern.compile("^(?:init|reconnect)$");
    public static Pattern options = Pattern.compile("^(?:server_param|player_param|player_type)$");
    public static Pattern errors = Pattern.compile("^(?:error|warning)$");
    public static Pattern line_pattern = Pattern.compile("^\\((\\w+?)\\s+(.*)\\)$");
    public static Pattern simple_control_pattern = Pattern.compile("^\\((\\w+?)\\)$");
    public static Pattern token_pattern = Pattern.compile("\\s*([\\w\\.-]+)\\b\\s*|.*?((?:\\([\\.\\(\\w-].*?[\\.\\w\\)-]\\))+?)");
    public static Pattern hear_pattern = Pattern.compile("\\s*([^\\s]+)\\b");
    public static Pattern var_value_p = Pattern.compile("^\\s*\\(([\\w-]+)\\s+([\\w\\.]+)\\)\\s*$");
    public static Pattern sensor_params_p = Pattern.compile("\\s*(\\d+)\\s*(.*)");
    public static Pattern split_objects_p = Pattern.compile("^\\(|\\)\\s+\\(|\\)$");
    public static Pattern objects_p = Pattern.compile("\\((.*?)\\)\\s+(.*)");
    public static Pattern sep_p = Pattern.compile("\\s");
    public static final int p_flags = 2;
    public static Pattern p_player = Pattern.compile("^(player|p)$", 2);
    public static Pattern p_ball = Pattern.compile("^(ball|b)$", 2);
    public static Pattern p_goal = Pattern.compile("^(goal|g)$", 2);
    public static Pattern p_flag = Pattern.compile("^(flag|f)$", 2);
    public static Pattern p_line = Pattern.compile("^(line|l)$", 2);
    public static Pattern p_quote = Pattern.compile("\"");
    public static Pattern p_lr = Pattern.compile("^(l|r)$");
    public static Pattern p_tb = Pattern.compile("^(t|b)$");
    public static Pattern p_pg = Pattern.compile("^(p|g)$");
    Matcher m;
    Matcher n;
    Matcher o;
    Matcher p;

    public void addPEListener(ParsingEventListener parsingEventListener) {
        this.PEListeners.add(parsingEventListener);
    }

    public void removePEListener(ParsingEventListener parsingEventListener) {
        this.PEListeners.remove(parsingEventListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParsedLine parse(String string) throws IOException {
        this.parsed.reset(this.cycle);
        this.m = line_pattern.matcher(string);
        if (this.m.matches()) {
            String string2 = this.m.group(1);
            String string3 = this.m.group(2);
            if (options.matcher(string2).matches()) {
                this.parseOptions(string2, string3);
                return this.parsed;
            } else if (init.matcher(string2).matches()) {
                this.parseInit(string2, string3);
                return this.parsed;
            } else if (controls.matcher(string2).matches()) {
                this.parseControl(string2, string3);
                return this.parsed;
            } else if (sensors.matcher(string2).matches()) {
                this.parseSensor(string2, string3);
                return this.parsed;
            } else {
                if (!errors.matcher(string2).matches()) throw new IOException("Not recognized message:\n" + string);
                this.parseError(string2, string3);
            }
            return this.parsed;
        } else {
            ParsingEvent parsingEvent;
            this.n = simple_control_pattern.matcher(string);
            if (!this.n.matches()) {
                throw new IOException("Not recognized simple control message:\n" + string);
            }
            String string4 = this.n.group(1);
            if (!simple_controls.matcher(string4).matches()) throw new IOException("Not a simple control:\n" + string);
            if (this.lastType.compareTo("sensor") == 0) {
                parsingEvent = new ParsingEvent(this);
                for (ParsingEventListener parsingEventListener : this.PEListeners) {
                    parsingEventListener.Controling(parsingEvent);
                }
            }
            this.lastType = "control";
            this.parsed.setControl(string4);
            parsingEvent = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.SimpleControl(parsingEvent);
            }
        }
        return this.parsed;
    }

    private void parseInit(String string, String string2) {
        this.parsed.setCycle(-1);
        this.cycle = -1;
        this.n = token_pattern.matcher(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.n.find()) {
            for (int i = 1; i <= this.n.groupCount(); ++i) {
                String string3 = this.n.group(i);
                if (string3 == null) continue;
                arrayList.add(string3);
            }
        }
        this.n = p_lr.matcher((CharSequence)arrayList.get(0));
        if (this.n.matches()) {
            if (this.lastType.compareTo("control") == 0) {
                ParsingEvent parsingEvent = new ParsingEvent(this);
                for (ParsingEventListener parsingEventListener : this.PEListeners) {
                    parsingEventListener.Sensing(parsingEvent);
                }
            }
            this.lastType = "control";
            this.parsed.setSensor(string);
            this.parsed.setParam("team_side", (String)arrayList.get(0));
            if (string.compareTo("init") == 0) {
                this.parsed.setParam("player_number", (String)arrayList.get(1));
                this.parsed.setParam("play_mode", (String)arrayList.get(2));
            } else {
                this.parsed.setParam("play_mode", (String)arrayList.get(1));
            }
            ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.ServerInit(parsingEvent);
            }
        } else {
            if (this.lastType.compareTo("sensor") == 0) {
                ParsingEvent parsingEvent = new ParsingEvent(this);
                for (ParsingEventListener parsingEventListener : this.PEListeners) {
                    parsingEventListener.Controling(parsingEvent);
                }
            }
            this.lastType = "control";
            this.parsed.setControl(string);
            this.parsed.setParam("team_name", p_quote.matcher((CharSequence)arrayList.get(0)).replaceAll(""));
            if (string.compareTo("init") == 0) {
                this.parsed.setParam("goalie", "0");
                for (int i = 1; i < arrayList.size(); ++i) {
                    this.o = simple_control_pattern.matcher((CharSequence)arrayList.get(i));
                    this.p = var_value_p.matcher((CharSequence)arrayList.get(i));
                    if (this.o.matches()) {
                        if (this.o.group(1).compareTo("goalie") != 0) continue;
                        this.parsed.setParam("goalie", "1");
                        continue;
                    }
                    if (!this.p.matches() || this.p.group(1).compareTo("version") != 0) continue;
                    this.parsed.setParam("protocol_version", this.p.group(2));
                }
            } else {
                this.parsed.setParam("player_number", (String)arrayList.get(1));
            }
            ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.ClientInit(parsingEvent);
            }
        }
    }

    private void parseControl(String string, String string2) {
        Object object;
        Serializable serializable;
        if (this.lastType.compareTo("sensor") == 0) {
            serializable = new ParsingEvent(this);
            for (ParsingEventListener object2 : this.PEListeners) {
                object2.Controling((ParsingEvent)serializable);
            }
        }
        this.lastType = "control";
        this.parsed.setControl(string);
        this.n = token_pattern.matcher(string2);
        serializable = new ArrayList();
        while (this.n.find()) {
            for (int i = 1; i <= this.n.groupCount(); ++i) {
                String string3 = this.n.group(i);
                if (string3 == null) continue;
                ((ArrayList)serializable).add(string3);
            }
        }
        if (string.compareTo("catch") == 0) {
            this.parsed.setParam("direction", (String)((ArrayList)serializable).get(0));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.Catch((ParsingEvent)object);
            }
        } else if (string.compareTo("change_view") == 0) {
            this.parsed.setParam("change_view_w", (String)((ArrayList)serializable).get(0));
            this.parsed.setParam("change_view_q", (String)((ArrayList)serializable).get(1));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.ChangeView((ParsingEvent)object);
            }
        } else if (string.compareTo("dash") == 0) {
            this.parsed.setParam("power", (String)((ArrayList)serializable).get(0));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.Dash((ParsingEvent)object);
            }
        } else if (string.compareTo("kick") == 0) {
            this.parsed.setParam("power", (String)((ArrayList)serializable).get(0));
            this.parsed.setParam("direction", (String)((ArrayList)serializable).get(1));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.Kick((ParsingEvent)object);
            }
        } else if (string.compareTo("move") == 0) {
            this.parsed.setParam("x", (String)((ArrayList)serializable).get(0));
            this.parsed.setParam("y", (String)((ArrayList)serializable).get(1));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.Move((ParsingEvent)object);
            }
        } else if (string.compareTo("say") == 0) {
            this.parsed.setParam("say", (String)((ArrayList)serializable).get(0));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.Say((ParsingEvent)object);
            }
        } else if (string.compareTo("turn") == 0) {
            this.parsed.setParam("direction", (String)((ArrayList)serializable).get(0));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.Turn((ParsingEvent)object);
            }
        } else if (string.compareTo("turn_neck") == 0) {
            this.parsed.setParam("neck_angle", (String)((ArrayList)serializable).get(0));
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.TurnNeck((ParsingEvent)object);
            }
        } else {
            object = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.OtherControl((ParsingEvent)object);
            }
        }
    }

    private void parseSensor(String string, String string2) throws IOException {
        block54: {
            Object object;
            Object object2;
            block56: {
                block55: {
                    block53: {
                        if (this.lastType.compareTo("control") == 0) {
                            object2 = new ParsingEvent(this);
                            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                                parsingEventListener.Sensing((ParsingEvent)object2);
                            }
                        }
                        this.lastType = "sensor";
                        this.parsed.setSensor(string);
                        this.n = sensor_params_p.matcher(string2);
                        if (!this.n.matches()) {
                            if (string.compareTo("ok") != 0) {
                                throw new IOException("No time on sensor message:\n" + string + " " + string2);
                            }
                            return;
                        }
                        this.cycle = Integer.parseInt(this.n.group(1));
                        object2 = this.n.group(2);
                        this.parsed.setCycle(this.cycle);
                        if (string.compareTo("hear") != 0) break block53;
                        this.n = hear_pattern.matcher((CharSequence)object2);
                        object = new ArrayList();
                        while (this.n.find()) {
                            for (int i = 1; i <= this.n.groupCount(); ++i) {
                                String string3 = this.n.group(i);
                                if (string3 == null) continue;
                                ((ArrayList)object).add(string3);
                            }
                        }
                        this.parsed.setParam("who", (String)((ArrayList)object).get(0));
                        this.parsed.setParam("what", (String)((ArrayList)object).get(1));
                        ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
                        for (ParsingEventListener parsingEventListener : this.PEListeners) {
                            parsingEventListener.Hear(parsingEvent);
                        }
                        break block54;
                    }
                    if (string.compareTo("score") != 0) break block55;
                    this.n = token_pattern.matcher((CharSequence)object2);
                    object = new ArrayList();
                    while (this.n.find()) {
                        for (int i = 1; i <= this.n.groupCount(); ++i) {
                            String string4 = this.n.group(i);
                            if (string4 == null) continue;
                            ((ArrayList)object).add(string4);
                        }
                    }
                    this.parsed.setParam("our_score", (String)((ArrayList)object).get(0));
                    this.parsed.setParam("their_score", (String)((ArrayList)object).get(1));
                    ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
                    for (ParsingEventListener parsingEventListener : this.PEListeners) {
                        parsingEventListener.Score(parsingEvent);
                    }
                    break block54;
                }
                if (string.compareTo("see") != 0) break block56;
                object = split_objects_p.split((CharSequence)object2);
                int n = 0;
                ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
                for (ParsingEventListener iterator : this.PEListeners) {
                    iterator.SeeReceived(parsingEvent);
                }
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object3;
                    String[] stringArray;
                    ParsedLine parsedLine = new ParsedLine();
                    this.n = objects_p.matcher((CharSequence)object[i]);
                    if (!this.n.matches()) continue;
                    String string3 = Integer.toString(++n);
                    String string4 = this.n.group(1);
                    String string5 = this.n.group(2);
                    String[] stringArray2 = sep_p.split(string4, 2);
                    this.parsed.setParam("type_" + string3, stringArray2[0]);
                    parsedLine.setParam("type", stringArray2[0]);
                    if (stringArray2.length > 1) {
                        if (p_player.matcher(stringArray2[0]).matches()) {
                            stringArray = sep_p.split(stringArray2[1]);
                            switch (stringArray.length) {
                                case 3: {
                                    if (stringArray[2].compareTo("goalie") == 0) {
                                        this.parsed.setParam("goalie_" + string3, "1");
                                        parsedLine.setParam("goalie", "1");
                                    }
                                }
                                case 2: {
                                    this.parsed.setParam("player_number_" + string3, stringArray[1]);
                                    parsedLine.setParam("player_number", stringArray[1]);
                                }
                            }
                            object3 = p_quote.matcher(stringArray[0]);
                            this.parsed.setParam("team_" + string3, ((Matcher)object3).replaceAll(""));
                            parsedLine.setParam("team", ((Matcher)object3).replaceAll(""));
                        } else if (p_flag.matcher(stringArray2[0]).matches()) {
                            stringArray = sep_p.split(stringArray2[1]);
                            switch (stringArray.length) {
                                case 1: {
                                    parsedLine.setParam("hp", "c");
                                    parsedLine.setParam("vp", "c");
                                    break;
                                }
                                case 2: {
                                    if (stringArray[0].compareTo("c") == 0) {
                                        parsedLine.setParam("hp", "c");
                                        parsedLine.setParam("vp", stringArray[1]);
                                        break;
                                    }
                                    if (p_lr.matcher(stringArray[0]).matches()) {
                                        parsedLine.setParam("hp", stringArray[0]);
                                        if (p_tb.matcher(stringArray[1]).matches()) {
                                            parsedLine.setParam("vp", stringArray[1]);
                                            break;
                                        }
                                        parsedLine.setParam("vp", "c");
                                        parsedLine.setParam("flag_number", "0");
                                        break;
                                    }
                                    parsedLine.setParam("hp", stringArray[0]);
                                    parsedLine.setParam("vp", "c");
                                    parsedLine.setParam("flag_number", "0");
                                    break;
                                }
                                case 3: {
                                    if (p_pg.matcher(stringArray[0]).matches()) {
                                        parsedLine.setParam("Box", stringArray[0]);
                                        parsedLine.setParam("hp", stringArray[1]);
                                        parsedLine.setParam("vp", stringArray[2]);
                                        break;
                                    }
                                    parsedLine.setParam("hp", stringArray[0]);
                                    parsedLine.setParam("vp", stringArray[1]);
                                    parsedLine.setParam("flag_number", stringArray[2]);
                                }
                            }
                        } else {
                            this.parsed.setParam("name_" + string3, stringArray2[1]);
                        }
                        parsedLine.setParam("name", stringArray2[1]);
                    }
                    stringArray = sep_p.split(string5);
                    switch (stringArray.length) {
                        case 6: {
                            this.parsed.setParam("head_dir_" + string3, stringArray[5]);
                            parsedLine.setParam("head_dir", stringArray[5]);
                        }
                        case 5: {
                            this.parsed.setParam("body_dir_" + string3, stringArray[4]);
                            parsedLine.setParam("body_dir", stringArray[4]);
                        }
                        case 4: {
                            this.parsed.setParam("dir_change_" + string3, stringArray[3]);
                            parsedLine.setParam("dir_change", stringArray[3]);
                        }
                        case 3: {
                            this.parsed.setParam("dist_change_" + string3, stringArray[2]);
                            parsedLine.setParam("dist_change", stringArray[2]);
                        }
                        case 2: {
                            this.parsed.setParam("direction_" + string3, stringArray[1]);
                            parsedLine.setParam("direction", stringArray[1]);
                            this.parsed.setParam("distance_" + string3, stringArray[0]);
                            parsedLine.setParam("distance", stringArray[0]);
                            break;
                        }
                        default: {
                            this.parsed.setParam("direction_" + string3, stringArray[0]);
                            parsedLine.setParam("direction", stringArray[0]);
                        }
                    }
                    object3 = new ParsingEvent(this, parsedLine);
                    if (p_player.matcher(stringArray2[0]).matches()) {
                        for (ParsingEventListener parsingEventListener : this.PEListeners) {
                            parsingEventListener.Player((ParsingEvent)object3);
                        }
                    }
                    if (p_ball.matcher(stringArray2[0]).matches()) {
                        for (ParsingEventListener parsingEventListener : this.PEListeners) {
                            parsingEventListener.Ball((ParsingEvent)object3);
                        }
                    }
                    if (p_flag.matcher(stringArray2[0]).matches()) {
                        for (ParsingEventListener parsingEventListener : this.PEListeners) {
                            parsingEventListener.Flag((ParsingEvent)object3);
                        }
                    }
                    if (p_line.matcher(stringArray2[0]).matches()) {
                        for (ParsingEventListener parsingEventListener : this.PEListeners) {
                            parsingEventListener.Line((ParsingEvent)object3);
                        }
                    }
                    if (!p_goal.matcher(stringArray2[0]).matches()) continue;
                    for (ParsingEventListener parsingEventListener : this.PEListeners) {
                        parsingEventListener.Goal((ParsingEvent)object3);
                    }
                }
                this.parsed.setParam("objects", Integer.toString(n));
                ParsingEvent parsingEvent2 = new ParsingEvent(this, this.parsed);
                for (ParsingEventListener parsingEventListener : this.PEListeners) {
                    parsingEventListener.SeeParsed(parsingEvent2);
                }
                break block54;
            }
            if (string.compareTo("sense_body") != 0) break block54;
            object = split_objects_p.split((CharSequence)object2);
            for (int i = 0; i < ((Object)object).length; ++i) {
                String[] stringArray = sep_p.split((CharSequence)object[i]);
                if (stringArray[0].compareTo("view_mode") == 0) {
                    this.parsed.setParam("view_q", (String)stringArray[1]);
                    this.parsed.setParam("view_w", (String)stringArray[2]);
                    continue;
                }
                if (((String)stringArray[0]).compareTo("stamina") == 0) {
                    this.parsed.setParam("stamina", (String)stringArray[1]);
                    this.parsed.setParam("effort", (String)stringArray[2]);
                    continue;
                }
                if (((String)stringArray[0]).compareTo("speed") == 0) {
                    this.parsed.setParam("speed", (String)stringArray[1]);
                    this.parsed.setParam("direction", (String)stringArray[2]);
                    continue;
                }
                if (((String)stringArray[0]).compareTo("head_angle") != 0) continue;
                this.parsed.setParam("head_direction", (String)stringArray[1]);
            }
            ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
            for (ParsingEventListener parsingEventListener : this.PEListeners) {
                parsingEventListener.SenseBody(parsingEvent);
            }
        }
    }

    private void parseOptions(String string, String string2) {
        this.parsed.setSensor(string);
        this.parsed.setParam("params", string2);
        this.parsed.setCycle(-1);
        ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
        for (ParsingEventListener parsingEventListener : this.PEListeners) {
            parsingEventListener.ServerParams(parsingEvent);
        }
    }

    private void parseError(String string, String string2) {
        this.parsed.setSensor(string);
        this.parsed.setParam("error", string2);
        this.parsed.setCycle(-2);
        ParsingEvent parsingEvent = new ParsingEvent(this, this.parsed);
        for (ParsingEventListener parsingEventListener : this.PEListeners) {
            parsingEventListener.Error(parsingEvent);
        }
    }
}

