/*
 * Decompiled with CFR 0.152.
 */
package org.RCSLogServer;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Vector;
import org.RCSLogServer.ClientServerComm;
import org.RCSLogServer.LogMemory;
import org.RCSLogServer.ServerClientComm;

public class RCSLogServer {
    private InetAddress s_host;
    private int s_init_port = 6000;
    private int s_port = 0;
    private int c_port = 0;
    private Vector<Thread> communication_list;
    private DatagramSocket listen_socket;

    public static void main(String[] stringArray) throws IOException {
        String string = new String("");
        int n = 6000;
        int n2 = 7000;
        try {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (stringArray[i].compareTo("-s_host") == 0) {
                    string = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].compareTo("-s_port") == 0) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].compareTo("-c_port") == 0) {
                    n2 = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                throw new Exception();
            }
        }
        catch (Exception exception) {
            System.err.println("");
            System.err.println("USAGE: java RCSLogServer [-parameter value]");
            System.err.println("");
            System.err.println("    Parameters  value        default");
            System.err.println("   ------------------------------------");
            System.err.println("    s_host      host_name    localhost");
            System.err.println("    s_port      port_number  6000");
            System.err.println("    c_port      port_number  7000");
            System.err.println("");
            System.err.println("    Example:");
            System.err.println("      java RCSLogServer -s_host 127.0.0.1 -s_port 6000 -c_port 7000");
            return;
        }
        System.out.println("Initializing RCSLogServer ...");
        RCSLogServer rCSLogServer = new RCSLogServer(InetAddress.getByName(string), n, n2);
        rCSLogServer.mainLoop();
    }

    public RCSLogServer(InetAddress inetAddress, int n, int n2) {
        this.s_host = inetAddress;
        this.s_init_port = n;
        this.communication_list = new Vector();
        try {
            this.listen_socket = new DatagramSocket(n2);
        }
        catch (SocketException socketException) {
            System.err.println("Unable to initialize socket connection on port " + Integer.toString(n2) + "...aborting.");
            System.exit(0);
        }
    }

    public void finalize() {
    }

    protected void mainLoop() {
        ClientServerComm clientServerComm = null;
        ServerClientComm serverClientComm = null;
        System.out.println("Starting RCSLogServer ...");
        System.out.println("\nAt any time, press ENTER key to stop.\n");
        boolean bl = false;
        while (!bl) {
            try {
                LogMemory logMemory = new LogMemory(this.s_host, this.s_init_port);
                serverClientComm = new ServerClientComm(logMemory);
                clientServerComm = new ClientServerComm(this.listen_socket, logMemory);
                System.out.println("Awaiting connection ... ");
                while (!logMemory.checkClient() && !bl) {
                    Thread.sleep(1000L);
                    bl = System.in.available() > 0;
                }
                this.communication_list.add(clientServerComm);
                this.communication_list.add(serverClientComm);
                while (!logMemory.checkServer() && !bl) {
                    Thread.sleep(1000L);
                    bl = System.in.available() > 0;
                }
                if (bl) continue;
                System.out.println("Logging initiated for: " + logMemory.getPlayerName() + " -> " + logMemory.getFilename());
            }
            catch (IOException iOException) {
                System.err.println("Input error: " + iOException);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Thread Interruption: inte");
            }
        }
        System.out.println("Initiating stop of communication threads.");
        ClientServerComm clientServerComm2 = null;
        ServerClientComm serverClientComm2 = null;
        for (int i = 0; i < this.communication_list.size(); i += 2) {
            clientServerComm2 = (ClientServerComm)this.communication_list.elementAt(i);
            serverClientComm2 = (ServerClientComm)this.communication_list.elementAt(i + 1);
            clientServerComm2.initiateStop();
            serverClientComm2.initiateStop();
        }
        System.exit(0);
    }
}

