/*
 * Created on May 25, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package rcscene;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Collection;
import java.text.NumberFormat;

/**
 * @author davidtudino
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class SceneStats {
	ArrayList sceneCounts;
	ArrayList sceneTimes;
	ArrayList sceneSelections;
	ArrayList sceneInitialMatches;
	HashMap matchedSceneInfo;
	
	int statsCounter;
	int uniqueScenes;
	
	int matchedKICK;
	int matchedTURN;
	int matchedTURNHEAD;
	int matchedDASH;
	
	int selectedKICK;
	int selectedTURN;
	int selectedTURNHEAD;
	int selectedDASH;
	
	int correctKICK;
	int correctTURN;
	int correctTURNHEAD;
	int correctDASH;
	
	int hitCount;
	int missCount;
	
	double avgCounts;
	double avgTimes;
	double avgMatches;
	
	public SceneStats () {
		sceneCounts = new ArrayList();
		sceneTimes = new ArrayList();
		sceneSelections = new ArrayList();
		sceneInitialMatches = new ArrayList();
		matchedSceneInfo = new HashMap();
		
		statsCounter = 0;
		uniqueScenes = 0;
		
		matchedKICK = 0;
		matchedTURN = 0;
		matchedTURNHEAD = 0;
		matchedDASH = 0;
		
		selectedKICK = 0;
		selectedTURN = 0;
		selectedTURNHEAD = 0;
		selectedDASH = 0;
		
		correctKICK = 0;
		correctTURN = 0;
		correctTURNHEAD = 0;
		correctDASH = 0;
		
		hitCount = 0;
		missCount = 0;
	}
	
	/*
	 * functions for adding information
	 */
	public void addSceneInfo (int count, long time, String sceneId, int matchCount, String sceneActions) {
		sceneCounts.add(statsCounter, new Integer(count));
		sceneTimes.add(statsCounter, new Long(time));
		sceneSelections.add(statsCounter, sceneId);
		sceneInitialMatches.add(statsCounter, new Integer(matchCount));
		statsCounter++;
		
		if (!matchedSceneInfo.containsKey(sceneId)) {
			matchedScenes newScene = new matchedScenes(sceneId, sceneActions);
			matchedSceneInfo.put(sceneId,newScene);
		} else {
			matchedScenes ms = (matchedScenes)matchedSceneInfo.get(sceneId);
			ms.addSceneOccurence();
		}
	}
	
	public void addSceneHit (String sceneId) {
		if (matchedSceneInfo.containsKey(sceneId)) {
			matchedScenes ms = (matchedScenes)matchedSceneInfo.get(sceneId);
			ms.addSceneHit();
		} else {
			//error!
		}
	}
	
	public void addSceneMiss (String sceneId) {
		if (matchedSceneInfo.containsKey(sceneId)) {
			matchedScenes ms = (matchedScenes)matchedSceneInfo.get(sceneId);
			ms.addSceneMiss();
		} else {
			//error!
		}
	}
	
	public void addCorrectDASH() {
		this.correctDASH++;
	}

	public void addCorrectKICK() {
		this.correctKICK++;
	}

	public void addCorrectTURN() {
		this.correctTURN++;
	}

	public void addCorrectTURNHEAD() {
		this.correctTURNHEAD++;
	}

	public void addMatchedDASH() {
		this.matchedDASH++;
	}

	public void addMatchedKICK() {
		this.matchedKICK++;
	}

	public void addMatchedTURN() {
		this.matchedTURN++;
	}

	public void addMatchedTURNHEAD() {
		this.matchedTURNHEAD++;
	}

	public void addSelectedDASH() {
		this.selectedDASH++;
	}

	public void addSelectedKICK() {
		this.selectedKICK++;
	}

	public void addSelectedTURN() {
		this.selectedTURN++;
	}

	public void addSelectedTURNHEAD() {
		this.selectedTURNHEAD++;
	}
	
	public void addHit () {
		this.hitCount++;
	}
	
	public void addMiss () {
		this.missCount++;
	}
	
	/*
	 * functions for calculating statistics
	 */
	public void calcAvgs () {
		int i;
		for (i = 0; i < statsCounter; i++) {
			avgCounts += ((Integer)sceneCounts.get(i)).doubleValue();
			avgTimes += ((Long)sceneTimes.get(i)).longValue();	
			avgMatches += ((Integer)sceneInitialMatches.get(i)).doubleValue();
		}
		avgCounts = avgCounts / (double)statsCounter;
		avgTimes = avgTimes / (double)statsCounter;
		avgMatches = avgMatches / (double)statsCounter;
	}

	private String getUniqueScenes () {
		String ids = new String();
		ids = "";
		
		for (int i = 0; i < statsCounter; i++) {
			if (ids.indexOf((String)sceneSelections.get(i)) == -1) {
				ids += (String)sceneSelections.get(i) + ", ";
				uniqueScenes++;
			}
		}
		
		return ids;
	}
	
	public String getStats () {
		String statsMsg = new String();
		String statsSceneIds = getUniqueScenes();
		NumberFormat n = NumberFormat.getInstance();
		n.setMaximumFractionDigits(2);
		n.setMinimumFractionDigits(2);
		
		int totalActions = hitCount + missCount;
		int totalKicks = selectedKICK + matchedKICK;
		int totalTurns = selectedTURN + matchedTURN;
		int totalTurnHead = selectedTURNHEAD + matchedTURNHEAD;
		int totalDash = selectedDASH + matchedDASH;
		
		double kickpc = 0;
		if (correctKICK > 0)
			kickpc = ((double)matchedKICK / (double)correctKICK) * 100;
		
		double turnpc = 0;
		if (correctTURN > 0 ) 
			turnpc = ((double)matchedTURN / (double)correctTURN) * 100;
		
		double thpc = 0;
		if (correctTURNHEAD > 0) 
			thpc = ((double)matchedTURNHEAD / (double)correctTURNHEAD) * 100;
		
		double dashpc = 0;
		if (correctDASH > 0) 
			dashpc = ((double)matchedDASH / (double)correctDASH) * 100;
		
		double accuracy = ((double)hitCount / (double)totalActions) * 100;
		
		statsMsg = "The number of cycles played in this game was: " + statsCounter + "\n";
		statsMsg += "The average number of scenes accessed per cycle was: " + n.format(avgCounts) + "\n";
		statsMsg += "The average number of miliseconds required to processes the scenes per cycle is: " + n.format(avgTimes) + "\n";
		//statsMsg += "The average number of matched scenes prior to selecting the action were: " + avgMatches + "\n";
		statsMsg += "\n";
		statsMsg += "Total Actions compared: " + (hitCount + missCount) + "\n";
		statsMsg += "Action\t\tTotal Performed\t\tTotal In Test Game\tTotal Correct\t% Correctly Matched\n";
		statsMsg += "KICK\t\t" + totalKicks + "\t\t\t" + correctKICK + "\t\t\t" + matchedKICK + "\t\t" + n.format(kickpc) + "\n";
		statsMsg += "TURN\t\t" + totalTurns + "\t\t\t" + correctTURN + "\t\t\t" + matchedTURN + "\t\t" + n.format(turnpc) + "\n";
		statsMsg += "TURNHEAD\t" + totalTurnHead + "\t\t\t" + correctTURNHEAD + "\t\t\t" + matchedTURNHEAD + "\t\t" + n.format(thpc) + "\n";
		statsMsg += "DASH\t\t" + totalDash + "\t\t\t" + correctDASH + "\t\t\t" + matchedDASH + "\t\t" + n.format(dashpc) + "\n";	
		//statsMsg += "Total KICK actions performed: " + totalKicks + ", Total matched KICK Actions: " + matchedKICK + ", Total KICK Actions in test game: " + correctKICK + ", corrected KICK action %: " + kickpc + "\n";
		//statsMsg += "Total TURN actions performed: " + totalTurns + ", Total matched TURN Actions: " + matchedTURN + ", Total TURN Actions in test game: " + correctTURN + ", corrected TURN action %: " + turnpc + "\n";
		//statsMsg += "Total TURNHEAD actions performed: " + totalTurnHead + ", Total matched TURNHEAD Actions: " + matchedTURNHEAD + ", Total TURNHEAD Actions in test game: " + correctTURNHEAD + ", corrected TURNHEAD action %: " + thpc + "\n";
		//statsMsg += "Total DASH actions performed: " + totalDash + ", Total matched DASH Actions: " + matchedDASH + ", Total DASH Actions in test game: " + correctDASH + ", corrected DASH action %: " + dashpc + "\n";
		statsMsg += "\n";
		statsMsg += "Total Correctly chosen actions: " + hitCount + "\n";
		statsMsg += "Total Incorrectly chosen actions: " + missCount + "\n";
		statsMsg += "Accuracy: " + n.format(accuracy) + "\n";
		statsMsg += "\n";
		statsMsg += "The number of unique scenes used during play where: " + uniqueScenes + "\n";
		//statsMsg += "The scenes selected were:\n" + statsSceneIds;
		
		statsMsg += "\nScene ID\tUsed\tMatched\t\tNot Matched\tCorrect %\tIncorrect %\tAction\n";
		
		Collection usedScenes = (Collection)matchedSceneInfo.values();
		Iterator iter = usedScenes.iterator();
		while (iter.hasNext()) {
			matchedScenes ms = (matchedScenes)iter.next();
		//	statsMsg += ms.getMatchedSceneStats();
		}
		
		return statsMsg;
	}
	
	
	public static void main(String[] args) {
		SceneStats testStats = new SceneStats();
		testStats.addSceneInfo(10,1,"1",1,"DASH");
		testStats.addSceneInfo(11,2,"2",3,"KICK");
		testStats.addSceneInfo(12,1,"1",4,"KICK");
		testStats.addSceneInfo(8,3,"3",5,"TURN");
		testStats.addSceneInfo(10,1,"1",3,"DASH");
		testStats.addSceneInfo(9,1,"2",4,"KICK");
		testStats.calcAvgs();
		System.out.println(testStats.getStats());			
	}
}

class matchedScenes {
	String sceneId;
	int sceneOccurences;
	int correctMatchCount;
	int incorrectMatchCount;
	String sceneAction;
	
	public matchedScenes () {
		sceneId = "";
		sceneAction = "";
		sceneOccurences = 0;
		correctMatchCount = 0;
		incorrectMatchCount = 0;
	}
	
	public matchedScenes (String scene_id, String scene_action) {
		sceneId = scene_id;
		sceneAction = scene_action;
		sceneOccurences = 1;
		correctMatchCount = 0;
		incorrectMatchCount = 0;
	}
	
	public void addSceneOccurence () {
		sceneOccurences++;
	}
	
	public void addSceneHit () {
		correctMatchCount++;
		//sceneOccurences++;
	}
	
	public void addSceneMiss () {
		incorrectMatchCount++;
		//sceneOccurences++;
	}
	
	public String getMatchedSceneStats () {
		String sceneOutPuts = "";
		NumberFormat n = NumberFormat.getInstance();
		n.setMaximumFractionDigits(2);
		n.setMinimumFractionDigits(2);
		
		double correctPCT, incorrectPCT;
		if (correctMatchCount == 0) {
			correctPCT = 0.0;
		} else {
			correctPCT = (double)(sceneOccurences / (double)correctMatchCount);
		}
		
		if (incorrectMatchCount == 0) {
			incorrectPCT = 0.0;
		} else {
			incorrectPCT = (double)(sceneOccurences / (double)incorrectMatchCount);
		}
		
		//sceneOutPuts = "Scene ID\t\tSelected\tCorrectly Matched\tIncorrectly Matched\tCorrect %\tIncorrect %\tAction\n";
		sceneOutPuts = sceneId + "\t\t"; 
		sceneOutPuts += sceneOccurences + "\t";
		sceneOutPuts += correctMatchCount + "\t\t";
		sceneOutPuts += incorrectMatchCount + "\t\t";
		sceneOutPuts += n.format(correctPCT) + "\t\t";
		sceneOutPuts += n.format(incorrectPCT) + "\t\t";
		sceneOutPuts += sceneAction;
		sceneOutPuts += "\n";
		
		return sceneOutPuts;
	}
	
	public void printMatchedSceneStats () {
		System.out.println(getMatchedSceneStats());
	}
}
