/*
 * Created on Aug 18, 2004
 *
 * Don't use me, I'm useless.  Just for testing/incremental development.
 * 
 * This is a nearest-neighbor distance-calculation algorithm that simply computes the Cartesian distances 
 * using the ball and the nearest goal (future work: detecting opponent vs my goal)
 * 
 * metric: (distance calc from me to goal) + (distance calc from me to ball)
 * 
 * changelog
 * 01/23/2005 - fixed subtraction bug, changed to proper cosine law calculation
 * 
 */
package sceneMatch.nearest_neighbor_matching;

import sceneInfo.ObjectInfo;
import sceneInfo.Scene;

/**
 * @author Kevin Lam
 *
 */
public class NearestNeighborBallGoalDistance extends NearestNeighborParent
{
	int kValue = 1;
	
	/**
	 * 
	 */
	public NearestNeighborBallGoalDistance(int k, char side)
	{
		super(k, side);
	}

	/* (non-Javadoc)
	 * @see rcscene.DistanceCalculation#distanceBetween(rcscene.VisionTable, rcscene.VisionTable)
	 */
	public float distanceBetween(Scene one, Scene two)
	{
		float dist1, dist2;
		float ballDist, goalDist;
		
		// if either of the visiontables has no ball, then distance is infinite
		// if both visiontables have no ball, then it's a match
		if ( (one.getBallObjects().size() == 0) && (two.getBallObjects().size() == 0) )
		{
			ballDist = 0;
		}
		// one or the other, but not both...
		else if ( (one.getBallObjects().size() == 0) || (two.getBallObjects().size() == 0) )
		{
			ballDist = 999;
		}
		else
		{
			// calculate the distance from me to the ball in object one, and two
			//ObjectInfo ballOne = (ObjectInfo) one.getBallObjects().elementAt(0);
			//ObjectInfo ballTwo = (ObjectInfo) two.getBallObjects().elementAt(0);
			ObjectInfo ballOne = (ObjectInfo) one.getBallObjects().get(0);
			ObjectInfo ballTwo = (ObjectInfo) two.getBallObjects().get(0);
			
			// and calculate.
			
			ballDist = polarDistance(ballOne.m_distance, ballOne.m_direction, ballTwo.m_distance, ballTwo.m_direction);
		}
		
		// similar for goal
		if ( (one.getGoalObjects().size() == 0) && (two.getGoalObjects().size() == 0) )
		{
			goalDist = 0;
		}
		// one or the other, but not both...
		else if ( (one.getGoalObjects().size() == 0) || (two.getGoalObjects().size() == 0) )
		{
			goalDist = 999;
		}
		else
		{
			// calculate the distance from me to the ball in object one, and two
			//ObjectInfo goalOne = (ObjectInfo) one.getGoalObjects().elementAt(0);
			//ObjectInfo goalTwo = (ObjectInfo) two.getGoalObjects().elementAt(0);
			ObjectInfo goalOne = (ObjectInfo) one.getGoalObjects().get(0);
			ObjectInfo goalTwo = (ObjectInfo) two.getGoalObjects().get(0);
			
			// and calculate.
			
			goalDist = polarDistance(goalOne.m_distance, goalOne.m_direction, goalTwo.m_distance, goalTwo.m_direction);
		}
		
		return ballDist + goalDist;
	}

}
