/*
 * Created on Aug 18, 2004
 *
 * This is the parent class for a nearest-neighbor distance-calculation algorithm.
 * 
 * changelog
 * 01/23/2005 - added support for object weights and polarDistance calculation
 */
package sceneMatch.nearest_neighbor_matching;

import java.util.*;
import rcscene.*;
import sceneInfo.*;

/**
 * @author kevlam
 *
 * This is the superclass for all nearest-neighbor algorithm implementations; just to save on some code duplication
 */
public class NearestNeighborParent implements DistanceCalculation
{
	 int kValue = 1;
	 char myside = 'l';
	
	 float weightBalls = 1;
	 float weightGoals = 1;
	 float weightFlags = 1;
	 float weightLines = 1;
	 float weightAllPlayers = 1;
	 float weightTeammates = 1;
	 float weightOpponents = 1;
	 float weightUnknownPlayers = 1;
	
	
	//counts the number of scenes looked during this call to
	//the distance calculation algorithms
	int viewSceneCount = 0;
		
	long viewSceneProcStart = 0;
	long viewSceneProcEnd = 0;
	
	/**
	 * get the scene count
	 *
	 */
	public int getSceneCount () {
		return viewSceneCount;
	}
	
	
	/**
	 * get the rough execution time of the scene calculation
	 *
	 */
	public long getSceneProcTime () {
		return (viewSceneProcEnd - viewSceneProcStart);
	}
	
	
	
	/**
	 * 
	 */
	private NearestNeighborParent()
	{
		kValue = 1;
	}

	/**
	 * 
	 */
	public NearestNeighborParent(int k, char side)
	{
		kValue = k;
		myside = side;
	}

	/* Subclass and improve this method!
	 * @see rcscene.DistanceCalculation#distanceBetween(rcscene.VisionTable, rcscene.VisionTable)
	 */
	public float distanceBetween(Scene one, Scene two)
	{
		return 0;
	}

	/* (non-Javadoc)
	 * 
	 * 	 @see rcscene.DistanceCalculation#findClosest(rcscene.VisionTable, java.util.List)
	 */
	public Scene[] findClosest(Scene key, List sceneSet)
	{
		float[] bestDistances = new float[kValue];
		Arrays.fill(bestDistances, 10000);
		
		Scene[] bestScenes = new Scene[kValue];
		Arrays.fill(bestScenes, null);

		
		//reset the scene counter
		viewSceneCount = 0;
		viewSceneProcStart = 0;
		viewSceneProcEnd = 0;
		
		viewSceneProcStart = System.currentTimeMillis();
		
		// iterate through list of Scenes, keep the ones with the best scores on distanceBetween...
		// note that we do not consider the Actions at all, just the VisionTables within the scenes
		Iterator it = sceneSet.iterator();
		while(it.hasNext()) 
		{
				//count
				viewSceneCount++;
				
					// calculate
					Scene two = (Scene) it.next();
					float dist = distanceBetween(key, two);
					
					// compare with all the current distances-between; if less than any one of them, swap it in
					for (int i = 0; i < kValue; i++)
					{
						if (Math.abs(dist) < Math.abs(bestDistances[i]) )
						{
							bestScenes[i] = two;
							bestDistances[i] = dist;
							break; 
						}
					}
		}
		
		viewSceneProcEnd = System.currentTimeMillis();
		
		return bestScenes;
		 
	}
	
	// rectilinear distance - for cells
	public float cartesianDistance(float x1, float y1, float x2, float y2)
	{
		double dist1 = (x2 - x1) * (x2 - x1);
		double dist2 = (y2 - y1) * (y2 - y1);

		float result = (float) Math.sqrt(dist1 + dist2);		
			
		return result;
	}

	// polar distance - using Cosine law - for discrete coordinates
	public float polarDistance(float r1, float th1, float r2, float th2)
	{
		// given a triangle with vertices at the player and at these two objects
		// dist^2 = r1^2 + r2^2 -2r1r2 cos (|th1-th2|)
		
		double part1 = (r1 * r1) + (r2 * r2);
		
		double theta = Math.abs(th2 - th1);
		
		double part2 = part1 - ( 2 * r1 * r2 * Math.cos(Math.toRadians(theta)) );
		
		if (part2 < 0)
		{
			part2 = 0;
			System.out.println("Error: dist^2 =" + part2 + "; setting to 0..");
		}
		
		float result = (float) Math.sqrt(part2);

		return result;
	}
	
	
	/* (non-Javadoc)
	 * @see rcscene.DistanceCalculation#setObjectWeights(float[])
	 */
	public void setObjectWeights(float[] weights)
	{
		// set object weights
		weightBalls = weights[0];
		weightGoals = weights[1];
		weightFlags = weights[2];
		weightLines = weights[3];
		weightAllPlayers = weights[4];
		weightTeammates = weights[5];
		weightOpponents = weights[6];
		weightUnknownPlayers = weights[7];
	}

}
