/*
 * Created on Sep 27, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package rcscene;

import java.io.*;
import java.util.*;

import sceneInfo.*;

public class LogToScenes {


	//Vector scenes = new Vector();
	//private ArrayList scenes = new ArrayList();
	
	//try writing to a scenelib
	SceneLib sceneLib = new SceneLib();
	
	//create a seperate scene library that will be storing visualinfo
	//items as a linked list, to be used by the new algorithm
	//SceneLib sceneLib2 = new SceneLib();
	
	private float dist = 0.0f;

	// this is the main function... its role is to do the following:
	// 1.  Read the log file
	// 2.  Create a Scene object representing each time cycle, adding to it every object we see on the field
	// 3.  Call the writeScenes() function at the end to write out the data to a file
	
	private String logFileName, sceneFileName;
	private int numRows = 3;
	private int numCols = 5;
	
	//number of pruned scenes
	private int prunedScenesCount = 0;
	
	public LogToScenes(String inLog, String outScene, int numRow, int numCol) {
		logFileName = inLog;
		sceneFileName = outScene;
		numRows = numRow;
		numCols = numCol;
		
		sceneLib = new SceneLib();
	}
	
	public static void main(String[] args)
	{

		//int linecount = 0;
		int numRows = 3;
		int numCols = 5;
		//int bin_count = 5;
		String inFile, outFile;
		
		LogToScenes lp;
		
		// look for parameters
		if (args.length < 2)
		{
			System.err.println(
				"LogToScenes - converts captured Robocup log files to Scenes");
			System.err.println("\nUsage: java LogToScenes in-file out-file [rows] [cols] [bin_count]");
			System.err.println("\nRows - specifies discretization levels for distances - default 3");
			System.err.println("Cols - specifies discretization levels for left/right angles - default 5");
			System.err.println("\nbin_count - bin count not supported just yet");
			
			System.err.println("\nTwo files will be written: out-file.scene and out-file.text (human-readable)\n");
			//System.err.println("\nOutput file is out-file.scene, which contains the sorted scene library.\n");
			return;
		}
		
		inFile = args[0];
		outFile = args[1];
		
		try {
			
				numRows = Integer.parseInt(args[2]);
				numCols = Integer.parseInt(args[3]);
				
				if (numRows < 1)
				{
					System.err.println("Error: invalid row size, reverting to default");
					numRows = 3;
				}
				if (numCols < 1)
				{
					System.err.println("Error: invalid column size, reverting to default");
					numCols = 5;
				}

		}
		catch (Exception e)
		{
				System.err.println("Error: unable to parse row/col size, using defaults");
				numRows = 3;
				numCols = 5;
		}		
		
		lp = new LogToScenes(inFile, outFile, numRows, numCols);
		
		//parse the log file
		lp.parseLog();			
		// now write out the scene file
		lp.writeScenes();

			
	}
	
	
	public void parseLog() {

		int linecount = 0;
		//int numRows = 3;
		//int numCols = 5;
        String my_team;

		StringTokenizer m_tokenizer;
		
		try
		{
			BufferedReader in = new BufferedReader(new FileReader(logFileName));
            StringBuffer test = new StringBuffer(logFileName.substring(logFileName.lastIndexOf("/")+1));
			my_team = new String(test);
			try {
				my_team = new String(test.substring(0,test.lastIndexOf("_")));		// default team name is the filename of the log
			}
			catch (Exception e)
			{
			}

			System.out.println("Using teamname " + my_team);

			System.out.println("Using table dimensions (" + numRows + ", " + numCols + ")");
						
			String str;
			String mytoken;

			Scene currentScene = new Scene(numRows, numCols);
			currentScene.setIdentString("0");		// the time stamp of this scene
			//////////////////////////////////////////
            currentScene.setTeamName(my_team);
            ////////////////////////////////////////////
            int currentTime = 0;					// easy integer representation of this scene's time
			
            
			System.out.println("Reading log data...");
			while ((str = in.readLine()) != null)
			{
				linecount++;		// just a counter for reporting purposes
				
				// step 1: tokenize first word

				str.trim();
				m_tokenizer = new StringTokenizer(str, "() ", true);
				if (m_tokenizer.hasMoreTokens())
				{
					m_tokenizer.nextToken(); // '('
					mytoken = m_tokenizer.nextToken(); // 'sense_body', etc.

					// step 2: based on word, pass to other functions as necessary
					//         right now we really only care about "see" and "sense_body" and the player actions

					if (mytoken.equals("init"))
					{
						m_tokenizer.nextToken();	// eat up the space
							String myTeamName = "\"" + m_tokenizer.nextToken() + "\"";
                            System.out.println("My team is " + myTeamName);
                            // Added by Deryck Velasquez 11/26/04: 
                            // Store the team name of the observer.
                            currentScene.setTeamName(myTeamName);
                            my_team = myTeamName;
							
					}
					if (mytoken.equals("sense_body"))
					{
						SenseBodyInfo logBody = new SenseBodyInfo(str);
						
						// ok, now we know about our own velocity and stamina and stuff... 
						// store somewhere in scene? currently no provision
						// should add later...
						
						if ((int)logBody.time == currentTime)
						{
							// attach the contents of logBody to the currentScene
						}
						else		// we've got a new time point.. so we must be done with the old one
						{
							sceneLib.placeScene(currentScene);
							
							currentScene = new Scene(numRows, numCols);
//							////////////////////////////////////////
							currentScene.setTeamName(my_team);
//							//////////////////////////////////////////
							currentScene.setIdentString("" + ((int)logBody.time));		// the time stamp of this scene
							
							currentTime = (int) logBody.time;
							
						}
						
						
					}
					else if (mytoken.equals("see"))
					{
						VisualInfo logSee = new VisualInfo(str, my_team, true);
						
						logSee.parse();
						if(logSee.getTime() != 0)
						{
							if (logSee.getTime() == currentTime)
							{
								parseSeeInfo(logSee, numRows, numCols);				// now logSee contains cell row/col info
								currentScene.setVision(logSee);						// what to do if one timepoint's data spans over two see's?
							}
							else		// we've got a new time point.. so we must be done with the old one
							{
								sceneLib.placeScene(currentScene);					
								
								currentScene = new Scene(numRows, numCols);
								currentScene.setIdentString("" + ((int)logSee.getTime()));		// the time stamp of this scene
								////////////////////////////////////////////
                                	currentScene.setTeamName(my_team);
                                	////////////////////////////////////////////
                                
                                currentTime = (int) logSee.getTime();
							
								//System.out.println("Parsing info for timestamp " + currentTime);
								parseSeeInfo(logSee, numRows, numCols);
								currentScene.setVision(logSee);
							}
						}
						
					}

					// actions
					// hard-coding it so that only 2 actions are stored
					else if (mytoken.equals("dash"))
					{
						Action newDash = new Action(Action.ACTION_DASH);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newDash.setActionPower(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newDash);
						//}
					}
					else if (mytoken.equals("turn"))
					{
						Action newTurn = new Action(Action.ACTION_TURN);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newTurn.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newTurn);
						//}
					}
					else if (mytoken.equals("turn_neck"))
					{
						Action newTurn = new Action(Action.ACTION_TURNNECK);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newTurn.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newTurn);
						//}
					}
					else if (mytoken.equals("kick"))
					{
						Action newKick = new Action(Action.ACTION_KICK);
						m_tokenizer.nextToken(); // the ' '
						
						// also set angle, power and stuff!
						newKick.setActionPower(Float.valueOf(m_tokenizer.nextToken()).floatValue()); 
						
						m_tokenizer.nextToken(); // the ' '
						
						newKick.setActionDirection(Float.valueOf(m_tokenizer.nextToken()).floatValue());
						 
						m_tokenizer.nextToken(); // the ')'
							
						//if (currentScene.getActions().size() < 2)
						//{
							currentScene.addAction(newKick);
						//}
					}
					else if (mytoken.equals("catch"))
					{
						//if (currentScene.getActions().size() < 2)
						//{

						currentScene.addAction(new Action(Action.ACTION_CATCH));
						// also set angle, power and stuff!
						//}
					}

					// otherwise ignore it, we don't care right now
				}
			}
			// is currentSlice = 6000 now, and not added?
			sceneLib.placeScene(currentScene);

			in.close();
			
			// finished reading file and building objects... 
			pruneScenes();
			
			//guessTargets();
			
			System.out.println(getPrunedSceneCount() + " scenes were pruned.");
			System.out.println("Done (read " + linecount + " lines).\n");
		}
		catch (Exception e) {

		}
	}
	
	/**
	 *  return an array of objectinfos, containing most likely target objects for action
	 */
	public static Vector predictTargets(Scene thisScene, Action thisAction, int confidence)
	{
		Vector likelyObjs = new Vector();
		
		double dir = thisAction.getActionDirection();
		
		Iterator objs = thisScene.getAllObjects().iterator();
		while (objs.hasNext())
		{
			// scan objects in the scene, look for matching directions
			ObjectInfo thisObject = (ObjectInfo) objs.next();
			double thisDir = thisObject.getDirection();
			if (Math.abs(thisDir - dir) <= confidence)
			{
				// directions are very similar, could be a match
				likelyObjs.add(thisObject);
			}
		}					
		
		return likelyObjs;
	}
	
	/**
	 * 
	 */
	private void guessTargets()
	{
		Iterator it = sceneLib.getSceneList().iterator();
		while (it.hasNext())
		{
			Scene thisScene = (Scene) it.next();
			
			// go through all the actions in this scene
			//System.out.println("Scene " + thisScene.getIdentString() + " action analysis:");
			Iterator acts = thisScene.getActions().iterator();
			while (acts.hasNext())
			{
				Action thisAction = (Action) acts.next();
				double dir = thisAction.getActionDirection();
				//System.out.println("  action " + thisAction + " in direction " + dir + " power " + thisAction.getActionPower());
				//System.out.println("  possible targets:");
				
				Vector simObjs = new Vector();
				
				Iterator objs = thisScene.getAllObjects().iterator();
				while (objs.hasNext())
				{
					// scan objects in the scene, look for matching directions
					ObjectInfo thisObject = (ObjectInfo) objs.next();
					double thisDir = thisObject.getDirection();
					if (Math.abs(thisDir - dir) < 2)
					{
						// directions are very similar, could be a match
						simObjs.add(thisObject);
						//System.out.println("  " + thisObject.getType() + ", dir "+ thisDir + " distance " + thisObject.getDistance());
					}
				}
				
				
			}

		}		
	}

	/**
	 * 
	 */
	private void pruneScenes()
	{
		int count = 0;
		
		System.out.print("Pruning scenes with no actions or visuals...");
		
		// iterate through the scenes, remove any empty or meaningless scenes
		Iterator it = sceneLib.getSceneList().iterator();
		while (it.hasNext())
		{
			Scene thisScene = (Scene) it.next();
			if (thisScene.getActions().size() == 0)
			{
				//System.out.println("Removing scene with no actions " + thisScene.getIdentString());
				it.remove();
				count++;
			}
			else if (thisScene.getAllObjects().size() == 0)
			{
				//System.out.println("Removing scene with no objects " + thisScene.getIdentString());
				it.remove();
				count++;
			}
		}								

		prunedScenesCount = count;
		
		System.out.println(count + " scenes removed.");
	}

	/**
	 * Will use this method to try to reduce the number of scenes in the 
	 * library by comparing them with each other. If there are scenes that
	 * closely match, one of them will be removed. The idea is to get rid of
	 * mutiple scenes that can be matched for a new target scene, thereby
	 * making the library more efficient, and opneing more room for more
	 * diverse scenes.

	private void pruneScenes()
	{
		//will need to make sure the same number of bins are used...
		SceneLib newlib = new SceneLib(sceneBins);
		Scene prunedScene;
		
		//get the algorithm
		sceneMatchAlgorithm matcher = new sceneMatchAlgorithm();
		
		int scenesPruned = 0;
		int failedCount = 0;
		boolean passedFlag = true;
		
		int badSetMatchCount = 0;
		
		int loopCount = 0;
		
		
		//will craete an array list for the matched scenes. each item
		//in the array list will be a bin of matched scenes. when complete
		//will go though each bin and get the sums for the scenes within, creating
		//a new scene for every bin
		ArrayList newScenes;//  = new ArrayList();
		
		//will loop through each of the scene bins, getting the scenes
		//and comparing them with each other
		//will keep track of the scene that it matched under the threshold 
		//with, and the distance
		for (int i = 0; i < sceneLib2.getNumBins(); i++) {
			ArrayList currBin = sceneLib2.getSceneBinByIndex(i);
			Iterator currBinIter = currBin.iterator();
			
			//System.out.println("Iterating through bin " + i);
			//System.out.println("Current bin size: " + currBin.size());
			//System.out.println("Current bin iterator.hasNext(): " + currBinIter.hasNext());
			
			
			while (currBinIter.hasNext()) {
			//for (int binCount = 0; binCount < currBin.size(); binCount++) {
				
				loopCount++;
				//System.out.println("bin: " + i + ", size: " + currBin.size() + ", loop: " + loopCount);
				
				
				//now we have the current scene
				Scene currScene = (Scene)currBinIter.next();
				//Scene currScene = (Scene)currBin.get(binCount);
				
				//don't use this scene if it has been used too many times
				//already
				if (currScene.getPruneCount() > pruneCount) {
					scenesPruned++;
					//break fetchScene;
				} else {
				
					//get the visualinfo
					VisualInfoBPM currVision = currScene.getBPMVision();
					
					//need to change the color of this scene for the algorithm
					//and make a copy of it for the new scene as well
					VisualInfoBPM newPrunedVision = new VisualInfoBPM(currVision.m_message, currScene.getTeamName(), !currVision.isBlue());
					newPrunedVision.parse();
					
					//need to compare this to all the others in this bin (currBin)
					//and get the set of matched scenes
					newScenes = matcher.findClosestSet(newPrunedVision, currBin, sceneThreshold, currScene.getActions());
					
					//System.out.println("Number of new scenes: " + newScenes.size());
					
					//check if there were any matches...
					if ((newScenes == null) || (newScenes.size() == 0)) {
						//System.out.println("newScenes was null or size = 0");
						//badSetMatchCount++;
						//break fetchScene;
						
						//wasn't matched with anything.. add it as it is
						newlib.placeScene(currScene, currScene.getSceneDistance());	
					} else {
						
						//now, we have an ArrayList of closely matched scenes
						//need to compare them, and calculate average points
						//which will be updated in newPrunedVision
						matcher.getSceneAvgs(newPrunedVision, newScenes);
						
						//test matched scenes, to see that they still fall within
						//the threshold.. 
						passedFlag = matcher.validatePruning(newPrunedVision, newScenes, sceneThreshold);
						
						if (!passedFlag)
							failedCount++;
						
						
						//now, add the matched visualinfo to a scene, and add the scene to the new
						//library
						parseSeeInfoBPM(newPrunedVision);
						
						prunedScene = new Scene();
						prunedScene.setIdentString(currScene.getIdentString());
						prunedScene.setTeamName(currScene.getTeamName());
						prunedScene.setVisionBPM(newPrunedVision);
						prunedScene.addActionList(currScene.getActions());
						
						newlib.placeScene(prunedScene, prunedScene.getSceneDistance());	
					}
				}
			}
		}

		System.out.println("\n\nCompleted Scene Pruning.\n\n");
		System.out.println("Completed with " + loopCount + " iterations");
		System.out.println("Pruned " + scenesPruned + " scenes.");
		System.out.println("Failed pruning validation on " + failedCount + " pruned scenes.");
		System.out.println("Found " + badSetMatchCount + " sets with 0 matches.");
		
		System.out.println("New Library:");
		newlib.showLibStats();
		
		sceneLib_p = newlib;
				
	}
	*/ 
	
	/**
	 * ParseSeeInfo -- iterate through a VisualInfo object; translate physical coordinates into cells/cols
	 * 
	 * This method is static because it is called upon by the modified Krislet brain to do this in real-time during a game
	 * Should maybe eventually move this to an external SceneGeneration object
	 * 
	 * @param vt
	 * @param logSee
	 */
	public static void parseSeeInfo(VisualInfo logSee, int numRows, int numCols)
	{
		placeObjects(logSee.getPlayerList(), numRows, numCols);
		placeObjects(logSee.getFlagList(), numRows, numCols);
		placeObjects(logSee.getGoalList(), numRows, numCols);
		placeObjects(logSee.getLineList(), numRows, numCols);
		placeObjects(logSee.getBallList(), numRows, numCols);
		
		if (logSee.getBallList() == null) {
			logSee.setSceneDist(0.0f);
		} else {
			ArrayList tmplst = logSee.getBallList();
			if (tmplst.size() > 0) {
				BallInfo tmpinfo = (BallInfo)tmplst.get(0);
				logSee.setSceneDist(tmpinfo.m_distance);
			} else {
				logSee.setSceneDist(0.0f);
			}
			
		}
	}
	
	
	// this function iterates through all ObjectInfo's in the list, adding row/col data to each
	private static void placeObjects(ArrayList objectList, int numRows, int numCols)
	{
		for (int i = 0; i < objectList.size(); i++)
		{
			ObjectInfo x = (ObjectInfo) objectList.get(i);
			
			// calculate which cell this object belongs to
			int cellx = whichslice(x.m_direction, numCols);
			int celly = whichdistance(x.m_distance, numRows);

			x.setTableColumn(cellx);
			x.setTableRow(celly);
		}
	}

	void writeScenes()
	{
		try
		{
			FileOutputStream fileOut = new FileOutputStream(sceneFileName + ".text");
			OutputStreamWriter outWriter =
				new OutputStreamWriter(fileOut, "US-ASCII");
			// throws exception
			PrintWriter out = new PrintWriter(outWriter); // throws exception
			
			System.out.println("Writing Scene Pictures file to " + sceneFileName + ".text");
			out.println("% Robocup Scene pictures generated by LogToScene.java");
			out.println("% Using rowsize=" + numRows + ", colsize=" + numCols);
			// iterate through objects here
			Iterator it = sceneLib.getSceneList().iterator();
			while (it.hasNext())
			{
				Scene thisScene = (Scene) it.next();

				out.println("Scene " + thisScene.getIdentString());
				out.println("Team " + thisScene.getTeamName());
				try {
				  out.println("# of Teammates/Oppos/Unknown = " + thisScene.getVision().getTeammatesList().size() + "/"
				  												+ thisScene.getVision().getOpponentsList().size() + "/"
																+ thisScene.getVision().getUnknownPlayersList().size());
				} catch(NullPointerException e) {}
				out.println("  table:\n" + thisScene.outputTable());
				out.println("  action:" + thisScene.getActions());
				Iterator actionIt = thisScene.getActions().iterator();
				while(actionIt.hasNext()) {
				  Action action = (Action) actionIt.next();
				  out.println("  actionDirection: " + action.getActionDirection() + "  actionPower: " + action.getActionPower());
				}
				out.println();
			}								

			// end of human-readable format...
			out.close();
			outWriter.close(); // throws exception
			fileOut.close();
			
			System.out.println("Writing Scene Store file to " + sceneFileName + ".scene");
			
			fileOut = new FileOutputStream(sceneFileName + ".scene");
			
			// future work: XML file?
			
			ObjectOutputStream oos = new ObjectOutputStream(fileOut);
			      oos.writeObject(new Integer(numRows));
			      oos.writeObject(new Integer(numCols));
				  oos.writeObject(sceneLib);
				  oos.close();
			fileOut.close();
			
		}
		catch (FileNotFoundException e)
		{

			e.printStackTrace();
		}
		catch (UnsupportedEncodingException e)
		{

			e.printStackTrace();
		}
		catch (IOException e)
		{

			e.printStackTrace();
		}
		
		System.out.println("Wrote " + sceneLib.getSceneList().size() + " scenes.");
		
	}

	/**
	 * Figure out which slice the given direction falls in
	 * next step: configurable number of slices
	 * @param f 	the distance
	 * @param numRows	the number of rows to use
	 * @return the distance slice to use
	 */
	private static int whichdistance(float f, int numRows)
	{
		// hard-coded to 3 for now; eventually will use numRows
		// we stick with 3 for now because that makes sense according to the server's own rules
		
		if (numRows != 3)
		{
			System.err.println("This version hard-codes the number of rows to 3.");
		}
		
		int distance = 0;
		
		// distance 0 is for objects less than 1 meter away
		// distance 1 is for objects 1-5 meters away
		// distance 2 is for everything past 5 meters
		if(f <= 1.4) return 0;
		else if ( (f >1.4 ) && (f<=5.0) ) return 1;
		else return 2;
	}

	/**
	 * Figure out which slice the given direction falls in
	 * slice formula: slice = (f + 180) / (360 / numslices)
	 * @param f the raw angle
	 * @param numslices the number of slices we want
	 * @return the slice number
	 */
	private static int whichslice(float f, int numslices)
	{
		if ( (f < -180.0) || (f > 180.0) )
		{
			System.err.println("Error!  Invalid angle!");
			return -1;
		}	
		if ( (numslices < 1) || (numslices > 360) )
		{
			System.err.println("Error!  Invalid slice number!");
			return -1;
		}	
		
		return (int)((f + 180.0) / (360 / numslices));
		
	}
	
	public int getPrunedSceneCount () {
		return prunedScenesCount;
	}
}


