/*
 * 
 * Created on Mar 1, 2004
 *
 * 03/29/2004: initial version
 * 10/19/2004: refactored to new version which directly references VisualInfos
 * 11/15/2004: included team-name change from Deryck Velasquez
 * 01/23/2005: added methods to access teammate/opponent lists
 * 
 * 
 */
package sceneInfo;

import java.io.Serializable;
import java.util.*;

import rcscene.Action;

/**
 * @author Kevin Lam
 *
 * A Scene is a representation of both a set of visuals (a VisualInfo) and a set of actions
 * associated with those visuals.
 * 
 */
public class Scene implements Serializable
{

	private VisualInfo vision = null;
	//private VisualInfoBPM visionBPM = null;
	
	private ArrayList actions = null;
	private String identString = null;		// typically a time index, but open to anything
	private int tableRows = 1;				// default sizes for cells
	private int tableColumns = 1;
    private String teamName = null;			// for RoboCup team names

    private int pruneCount = 0;
    
	/**
	 * 
	 */
	public Scene()
	{
		super();
		actions = new ArrayList();
	}

	/**
	 * 
	 */
	public Scene(int numRows, int numCols)
	{
		super();
		tableRows = numRows;
		tableColumns = numCols;
		actions = new ArrayList();
	}

	/**
	 * 
	 */
	public Scene(VisualInfo vis, Action act)
	{
		super();
		actions = new ArrayList();
		vision = vis;
		actions.add(act);
	}

	/**
	 * @return
	 */
	public ArrayList getActions()
	{
		return actions;
	}

	/**
	 * @param action
	 */
	public void addAction(Action action)
	{
		actions.add( action );
	}

	/**
	 * @param action
	 */
	public void removeAction(Action action)
	{
		actions.remove( action );
	}

	public void addActionList (ArrayList actionlist) {
		actions = actionlist;
	}
	
	// may need to redo the "actions" equals test
	// testing for exact matches, as opposed to identical sets
	public boolean equals(Scene other)
	{
		if ( (actions.equals(other.getActions())) && (vision.equals(other.getVision())) )
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	/**
	 * Don't get the VisualInfo manually; instead, use the other getter methods to get by type or by cell location
	 * @return
	 */
	public VisualInfo getVision()
	{
		return vision;
	}

	public ArrayList getAllObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getObjects();
	}
	
	public Vector getObjectsAt(int col, int row)
	{
		Vector results = new Vector();
		if (vision != null)
		{
			// iterate through all objects; copy the ones whose location matches this cell
			Iterator it = vision.getObjects().iterator();
			while (it.hasNext())
			{
				ObjectInfo obj = (ObjectInfo) it.next();
				if ( (obj.m_tableCol == col) && (obj.m_tableRow == row) )
				{
					// match
					results.add(obj);
				}
			}
		}

		return results;
	}
	
	public ArrayList getBallObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getBallList();
	}

	public ArrayList getLineObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getLineList();
	}
		
	public ArrayList getFlagObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getFlagList();
	}
	
	public ArrayList getPlayerObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getPlayerList();
	}
	public ArrayList getTeammateObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getTeammatesList();
	}
	public ArrayList getOpponentObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getOpponentsList();
	}
	public ArrayList getUnknownPlayerObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getUnknownPlayersList();
	}
	
	public ArrayList getGoalObjects()
	{
		if (vision == null)
			return new ArrayList();
		else
			return vision.getGoalList();
	}

	/**
	 * @param vis
	 */
	public void setVision(VisualInfo vis)
	{
		vision = vis;
	}
	
		
	/**
	 * @return
	 */
	public String getIdentString()
	{
		return identString;
	}

	/**
	 * @param string
	 */
	public void setIdentString(String string)
	{
		identString = string;
	}

	/**
	 * @author Deryck Velasquez
         * @version 1.0
	 */
	public String getTeamName()
	{
		return teamName;
	}

	/**
	 * @author Deryck Velasquez
         * @version 1.0
	 */
	public void setTeamName(String _teamName)
	{
		teamName = _teamName;
	}        
        
	// other Scene functions here (formerly defined in VisionTable)

	/**
	 * @param string
	 */
	public String outputTable()
	{
		if (vision == null)
			return "no table";
		else
		{
			String x = new String("");
			x = x.concat(outputRowMarkings());
			for (int i = 0; i < tableRows; i++)
			{
				for(int j = 0; j < tableColumns; j++)
				{
					x = x.concat("|" + outputCell(tableRows - i - 1, j) );
				}
				x = x.concat("|\n");
				x = x.concat(outputRowMarkings());
			}
				
			return x;
		}
	}
	
	private String outputCell(int row, int column)
	{
		String x = new String();
		Vector stuff = getObjectsAt(column, row);

		// output format is:  "BG 3P3F3L"
		x = x.concat( getBallCount(stuff) > 0 ? "B" : " ");
		x = x.concat( getGoalCount(stuff) > 0 ? "G " : "  ");

		int count = getPlayerCount(stuff);
		x = x.concat( count > 0 ? count + "P" : "  ");
		count = getFlagCount(stuff);
		x = x.concat( count > 0 ? count + "F" : "  ");
		count = getLineCount(stuff);
		x = x.concat( count > 0 ? count + "L" : "  ");
		
		return x;
	}
	private String outputRowMarkings()
	{
		String x = new String();
		for(int i = 0; i < tableColumns; i++)
		{
			x = x.concat("+---------");
		}
		x = x.concat("+\n");
		return x;
	}

	/**
	 * @return
	 */
	public int getTableColumns()
	{
		return tableColumns;
	}

	/**
	 * @return
	 */
	public int getTableRows()
	{
		return tableRows;
	}

	/**
	 * @param i
	 */
	public void setTableColumns(int i)
	{
		tableColumns = i;
	}

	/**
	 * @param i
	 */
	public void setTableRows(int i)
	{
		tableRows = i;
	}

	public int getPlayerCount(Vector list)
	{
			int c = 0;
        
			for (int i = 0; i < list.size(); i++)
			{
					ObjectInfo x = (ObjectInfo) list.elementAt(i);
					if (x.m_type.startsWith("player"))  
							c++;
			}
			return c;
	}

	public int getBallCount(Vector list)
	{
			int c = 0;
        
			for (int i = 0; i < list.size(); i++)
			{
					ObjectInfo x = (ObjectInfo) list.elementAt(i);
					if (x.m_type.startsWith("ball"))  
							c++;
			}
			return c;
	}

	public int getGoalCount(Vector list)
	{
			int c = 0;
        
			for (int i = 0; i < list.size(); i++)
			{
					ObjectInfo x = (ObjectInfo) list.elementAt(i);
					if (x.m_type.startsWith("goal"))  
							c++;
			}
			return c;
	}

	public int getFlagCount(Vector list)
	{
			int c = 0;
        
			for (int i = 0; i < list.size(); i++)
			{
					ObjectInfo x = (ObjectInfo) list.elementAt(i);
					if (x.m_type.startsWith("flag"))  
							c++;
			}
			return c;
	}

	public int getLineCount(Vector list)
	{
			int c = 0;
        
			for (int i = 0; i < list.size(); i++)
			{
					ObjectInfo x = (ObjectInfo) list.elementAt(i);
					if (x.m_type.startsWith("line"))  
							c++;
			}
			return c;
	}

	public float getSceneDistance () {
			if (vision == null) {
				return 250.0f;
			} else {
				return vision.getSceneDist();
			}
	}
	
	public int getPruneCount () {
		return pruneCount;
	}
	
	public void incPruneCount () {
		pruneCount++;
	}
}
