/*
 * Created on 26-Jul-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package sceneInfo;

import java.io.Serializable;
import java.util.*;

/**
 * The SceneLib class will contain the scene library. A sorted list will
 * be used to help reduce the number of scenes that need to be returned 
 * to the scene matching algorithm.
 * 
 * Modified from original: removed bins to separate subclass
 * 
 * @author david.tudino
 * @author kevlam
 */
public class SceneLib implements Serializable {

	private ArrayList orderedScenes;
	
	public SceneLib () {
		
		orderedScenes = new ArrayList();
	}
	
	//get the list of scenes that are within the range of 
	//the given distance
	public ArrayList getSceneList (float dist) {

		return orderedScenes;
	}
	
	public int size()
	{
		return orderedScenes.size();
	}

	//get the list of all scenes
	public ArrayList getSceneList () {

		return orderedScenes;
	}
	
	public void placeScene (Scene newScene) {
		//first check if this scene has an action or visual info...
		//if not, don't add it
		if ((newScene.getActions() == null) || (newScene.getVision() == null)) {
			//System.out.println("Skipped adding a scene because actions or visualinfo were null.");
			return;
		}
		
		if (newScene.getActions().size() == 0) {
			//System.out.println("Skipped adding a scene because actions set was empty.");
			return;
		}
		
		orderedScenes.add(newScene);
	}
	
}
