/*
 * Created on 26-Jul-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package sceneInfo;

import java.io.Serializable;
import java.util.*;

/**
 * The SceneLib class will contain the scene library. A sorted list will
 * be used to help reduce the number of scenes that need to be returned 
 * to the scene matching algorithm.
 * 
 * @author david.tudino
 */
public class SceneLibBins extends SceneLib implements Serializable {

	private ArrayList orderedScenes;
	private float[] hashKeys;
	private int numBins;
	
	public SceneLibBins () {
		numBins = 6;
		
		hashKeys = new float[6];
		hashKeys[0] = 0.0f;
		hashKeys[1] = 20.0f;
		hashKeys[2] = 40.0f;
		hashKeys[3] = 60.0f;
		hashKeys[4] = 80.0f;
		hashKeys[5] = 100.0f;
		
		orderedScenes = new ArrayList(6);
		orderedScenes.add(0, new ArrayList());
		orderedScenes.add(1, new ArrayList());
		orderedScenes.add(2, new ArrayList());
		orderedScenes.add(3, new ArrayList());
		orderedScenes.add(4, new ArrayList());
		orderedScenes.add(5, new ArrayList());
	}
	
	public SceneLibBins (int numBins) {
		this.numBins = numBins;
		float binSize = (100.0f / ((float)numBins));
		
		hashKeys = new float[numBins];
		hashKeys[0] = 0.0f;
		for (int k = 1; k < numBins; k++) {
			hashKeys[k] = binSize * k;
		}
		
		orderedScenes = new ArrayList(numBins);
		for (int i = 0; i < numBins; i++) {
			orderedScenes.add(i, new ArrayList());
		}
	}
	
	//get the list of scenes that are within the range of 
	//the given distance
	public ArrayList getSceneList (float dist) {
		int sceneSetBin = getSceneBin(dist);
		ArrayList sceneSet = (ArrayList)orderedScenes.get(sceneSetBin);

		//if there are no scenes in that bin, then move a bin downwards
		//until you get a bin with scenes
		while (sceneSet.size() == 0) {
			sceneSetBin--;
			sceneSet = (ArrayList)orderedScenes.get(sceneSetBin);
		}

		return sceneSet;
	}
	
	public void placeScene (Scene newScene) {
		//first check if this scene has an action or visual info...
		//if not, don't add it
		if ((newScene.getActions() == null) || (newScene.getVision() == null)) {
			//System.out.println("Skipped adding a scene because actions or visualinfo were null.");
			return;
		}
		
		if (newScene.getActions().size() == 0) {
			//System.out.println("Skipped adding a scene because actions set was empty.");
			return;
		}
		
		float dist = 0; // TODO: extract dist from Scene object
		
		//System.out.println("placing scene with distance " + dist + " into bin " + getSceneBin(dist));
		ArrayList destList = (ArrayList)orderedScenes.get(getSceneBin(dist));
		destList.add(newScene);
	}
	
	//public ArrayList getScenes (float dist) {
	//	return (ArrayList)orderedScenes.get(getSceneBin(dist));
	//}
	
	private int getSceneBin (float dist) {
		int list = 99;
		for (int i = 0; i < hashKeys.length; i++) {
			if (hashKeys[i] <= dist) {
				list = i;
			} else {
				break;
			}
		}
		return list;
	}
	
	public ArrayList getSceneBinByIndex (int bindex) {
		return (ArrayList)orderedScenes.get(bindex);
	}
	
	public int getNumBins () {
		return numBins;
	}
	
	public void showLibStats () {
		int totalCount = 0;
		
		for (int i = 0; i < hashKeys.length; i++) {
			ArrayList curLst = (ArrayList)orderedScenes.get(i);
			System.out.println(curLst.size() + 
					" scenes in bin " + i + ", for distance < " + hashKeys[i]);
			totalCount += curLst.size();
			curLst = null;
		}
		System.out.println("Total Scenes in library: " + totalCount);
	}
}
