// Bipartite_Perfect_Matching.java - Michael Maguire - 28 Apr 96

package sceneMatch.bipartite_perfect_matching;

import sceneMatch.Algorithm_Support;
import sceneMatch.Algorithms_Provide;
import sceneMatch.MatchNode;

import java.util.Stack;
import java.util.ArrayList;

//import sceneMatch.node;
//import matching.node;

import java.awt.*; //for debugging

// rougly, we use a multi-linked binary tree:
//	each node Y has a pointer "left" called tight_away_from_tree_root,
// 	a pointer "right" called sibling -- these two are used for traversing the
// binary tree
//	-- and a pointer sort of back "up" the tree called tight_towards_tree_root
// 	to the node with which node Y is tight -- used in augmenting only
//  -- sibling is used only in nodes of colour opposite to tree_root and
// indicates
//	other nodes which have been bumped by the node "up" indicated in
// tight_towards_tree_root
//

//											

// the picture: tree_root: X
//                                                                _
//                                                               /| ^ ^
//                                                              / /|\/|\
//                                                             |_ | |
//                                                                  | |
//                                                    O | |
//		    tight_towards_tree_root _ \ | |
//									/| \ | |
//								   / _|| | tight_towards_tree_root
//	  	tight_away_from_tree_root |_ | |
//										    O |
//								X _ \ |
//										 /| \ |
//										/ _||
//									  |_ |
//											     O
//									 X _ \ sibling
//								  _ /| \
//								  /|/|\ / _|
//								 / | |_
//								|_ | O
//									 | X
//							  O |
//								\ |
//						 sibling \ | tight_towards_tree_root
//								 _| |
//									 O
//
//									etc.
//
//

/*
class node
{
	short node_number;

	float radius;

	node spouse;

	node tight_towards_tree_root, tight_away_from_tree_root, sibling;

	node next_node;

	boolean counted = false;
	
	public boolean is_blue = false;
	
	float x;
	float y;
	
	float distance_to( node other_node )
	{
		return( (float)(  Math.sqrt( (x - other_node.x)*(x - other_node.x) +
				(y - other_node.y)*(y - other_node.y) ) ) );
	}
}
*/

public class Algorithm implements Algorithms_Provide

{

	private Algorithm_Support support; // what we can rely on for input and
									   // output

	private MatchNode first_node;

	private MatchNode tree_root;

	private MatchNode the_bumper; // the node in the tree which grows to bump some
							 // node out of the tree

	private MatchNode the_bumpee; // the node out of the tree which gets bumped

	private float distance_by_which_to_change;

	private boolean augmenting_needs_doing;

	private MatchNode current_augment_node;

	private boolean algorithm_done;
	

	public Algorithm()
	{
		//support = the_support;
		first_node = null;
		tree_root = null;
		the_bumper = null;
		the_bumpee = null;
		current_augment_node = null;
		augmenting_needs_doing = false;
		algorithm_done = false;
	}
	
	
	public Algorithm(Algorithm_Support the_support, short number_of_nodes)

	{

		support = the_support;

		short node_number_counter;

		first_node = null;

		tree_root = null;

		the_bumper = null;

		the_bumpee = null;

		current_augment_node = null;

		augmenting_needs_doing = false;
		
		for (node_number_counter = 1; node_number_counter <= number_of_nodes; node_number_counter++)
		{
			//add_node();
		}

	}
	
	/*
	public Algorithm(Algorithm_Support the_support, short number_of_nodes, node nodetree_root)
	{
		support = the_support;
		short node_number_counter;
		first_node = nodetree_root;
		tree_root = null;
		the_bumper = null;
		the_bumpee = null;
		current_augment_node = null;
		augmenting_needs_doing = false;
	}
	*/
	
	
	public void close()
	{

	}

	public float run_algorithm (MatchNode nodeset) {
		//System.out.println("In run_algorithm, before while loop ");
		float distance = 0.0f;
		algorithm_done = false;
		augmenting_needs_doing = true;
		first_node = nodeset;
		
		//System.out.println("starting timer...");
		long start_time = System.currentTimeMillis();
		
		//System.out.println("starting step loop...");
		while (!algorithm_done)
		{
			//this is always 0... 
			//the_algorithm.step(node_to_step_algorithm_with);
			//System.out.println("calling step(0)...");
			step((short)0);
		}
		
		//System.out.println("Done");
		distance = calc_distance();
		//System.out.println("Distance from edges: " + edges.get_total_distance());
		long end_time = System.currentTimeMillis();
		//System.out.println("Execution time: " + (end_time - start_time));
		
		return distance;
	}
	
	
	
	public boolean step(short node_number)
	{
		//System.out.println("inside step...");
		
		// safety check to see if we are totally done
		if (find_first_eligible_node() == null && !augmenting_needs_doing)
		{
			//System.out.println("did not find an eligible node...");
			//set algorithm_done here as well, since this is a check for being
			//done...
			algorithm_done = true;
			return (false);
		}

		if (augmenting_needs_doing)
		{
			// do one more step in the augmentation

			augment();

			// check to see if we are back at the tree root now, in which case
			// clean
			// 	up the tree and tell the world we are done augmenting, and
			// 	check to see if we are possibly totally done

			if (current_augment_node == tree_root)
			{

				augmenting_needs_doing = false;

				//reset_tree(tree_root); // we want no more tree, i.e.: tree_root
									   // = null, and

				// 	all tight_towards_tree_root's, tight_away_from_tree_root's
				// and sibling's = null

				// check to see if this augmentation was the last one
				//  i.e. are we totally done?

				if (find_first_eligible_node() == null)
				{

					//support.output_done();

					///////////////////////////////////////////////////////
					//algorithm_done = false;
					//shouldn't this be true?
					algorithm_done = true;
					
				}
				else // there are more eligible nodes, so tell the world we're
					 // waiting
				{

				}

			}
			else // we still have more augmenting to do
			{

			}

		}
		else // no augmenting needs doing at the moment
		{
			// safety checks
			if (node_number < 0)

				return (false); // invalid node_number

			// check first to see if we need a new node to start from

			// 	i.e.: check to see if there isn't already a tree root

			if (tree_root == null)
			{

				// check to see if we were told to find our own node

				if (node_number == 0)
				{
					tree_root = find_first_eligible_node();
				}
				else // we were given a node, let's see if it's valid
				{
					tree_root = find_node_with_number(node_number);

					// do we have a node at all?

					if (tree_root != null)
					{
						// is it married?

						if (tree_root.spouse != null)
						{

							// reset tree_root, so we look for a new one next
							// time

							tree_root = null;

							return (false); // the node has a spouse, so it is
											// invalid
						}
					}
					else
						return (false); // tree_root was null, so the
										// node_number was invalid
				}


			}

			// find the first node in the tree with the same colour as tree_root
			// which
			// 	will bump a node of opposite colour not in the tree

			distance_by_which_to_change = 10000000.0f; // something big so that
													   // checking for minimum
													   // works

			the_bumper = null;

			the_bumpee = null;

			find_the_next_bump(tree_root);

			// we set the radiuses of the nodes in the trees and set up the
			// animation shrinks and grows
			// 	this should be done before we add the bumpee (and possibly it's
			// spouse) to the tree

			shrink_and_grow_the_tree(tree_root);

			// we set the distance by which to change for the animation now --
			// it doesn't matter
			// 	when we do this as long as it's done before this function we're
			// in now returns

			//support.output_change_by(distance_by_which_to_change);

			// safety check

			if (the_bumper != null && the_bumpee != null)
			{

				// set up the animation to show a tight line to the node with
				// which we've bumped

				//support.output_add_tight_line(the_bumper.node_number,
				//		the_bumpee.node_number);

				// add the bumpee to the tree

				the_bumpee.tight_towards_tree_root = the_bumper;

				if (the_bumper.tight_away_from_tree_root == null)
				{
					// the Bumper is not already tight with any other node, so
					// just do this:

					the_bumper.tight_away_from_tree_root = the_bumpee;
				}
				else
				{
					// the_bumper is already tight with some nodes, so call a
					// routine to make
					// 	it tight with the_bumpee as well

					make_node_tight_with_a_further_node(
							the_bumper.tight_away_from_tree_root, the_bumpee);
				}

				// check to see whether the bumpee is married or not and act
				// accordingly

				if (the_bumpee.spouse != null)
				{
					// add the bumpee's spouse to the tree as well

					the_bumpee.tight_away_from_tree_root = the_bumpee.spouse;

					the_bumpee.spouse.tight_towards_tree_root = the_bumpee;

				}
				else
				{

					// we have a breakthrough, so set the ball rolling to
					// augment the marriages
					// 	in the path from the bumpee all the way back to tree_root

					current_augment_node = the_bumpee;

					augmenting_needs_doing = true;

				}

			} 
			else {
				//just added this else block now, to try to stop the loop
				//if there are two nodes in the same position - they seem to
				//lock up because nothing is increasing or decreasing! :(
				augmenting_needs_doing = false;
			}

		}

		// if we made it this far, then either the node number we were passed
		// was valid or
		// 	we weren't looking for a node number anyway, so tell the world that
		// the node number
		// 	we were passed was o.k.

		return (true);

	}

	private MatchNode find_node_with_number(short node_number)
	// returns null if no node of node_number was found
	{

		MatchNode temp_node;

		short node_number_counter;

		// safety check

		if (node_number <= 0)

			return (null); // we were passed an invalid node_number

		// now look through the nodes until temp_node == null or counter >=
		// node_number

		temp_node = first_node;

		node_number_counter = 1;

		while (temp_node != null && node_number_counter < node_number)
		{
			temp_node = temp_node.next_node;

			node_number_counter++;
		}

		// now temp_node will either handle to the correct node, or to null

		// 	if a node of node_number isn't in the list

		return (temp_node);

	}

	private MatchNode find_first_eligible_node()
	{
		//System.out.println("inside find_first_eligible_node()...");
		
		// returns null if no unmarried node was found
		MatchNode temp_node, eligible_node = null;

		// now look through the nodes until we find an unmarried node

		for (temp_node = first_node; temp_node != null && eligible_node == null; temp_node = temp_node.next_node)
		{
			if (temp_node.spouse == null)

				eligible_node = temp_node;
				
				//if( ! same_colour( temp_node, eligible_node ) )
					//eligible_node = temp_node;
		}


		// we don't want to check for this anymore, just let things go to
		// infinity
		// so that a maximal minimum weight implementation can be done later
		  
		  
		// now look through the nodes, making sure there is a node of
		// opposite
		// colour for the first node to marry
 
		  
		for( temp_node = first_node; temp_node != null; temp_node=temp_node.next_node )
		{
			if( temp_node.spouse == null )
			{
				// now check to see if it's of opposite colour
				
				if( ! same_colour( temp_node, eligible_node ) )
					return( eligible_node );
			}
		}
		
		// if we got to this point, there isn't an unmarried node in the
		//  list
		// 	or there is an eligible node, but there is no one whom it could
		//  marry
		return( null );

		//return (eligible_node); //original
	}

	private boolean same_colour(MatchNode node1, MatchNode node2)
	{
		// safety check
		if (node1 == null || node2 == null)
			return (false); // one or more invalid nodes

		// now check their colours
		//if (support.input_is_node_blue(node1.node_number) == support
			//	.input_is_node_blue(node2.node_number))
		if (node1.is_blue == node2.is_blue)
			return (true);
		else
			return (false);

	}

	private void shrink_and_grow_the_tree(MatchNode the_node)
	{
		
		//will use a stack to keep track of nodes
		//don't want to use a stack object, but hopefully will
		//help stop stackoverflow and won't be too slow
		Stack backNodes = new Stack();
		//ArrayList backNodes = new ArrayList();
		//int arrayIdx = 0;
		
		//MatchNode start_node = the_node;
		//MatchNode tmp_node = the_node;
		
		if (the_node == null) {
			return;
		}
		
		//rather than search the tree recursively, will depth-first
		//search it
		backNodes.push(the_node);
		//backNodes.add(the_node);
		while (!backNodes.empty()) {
		//while (!backNodes.isEmpty()) {
			MatchNode tmp_node = (MatchNode)backNodes.pop();
			//MatchNode tmp_node = (MatchNode)backNodes.remove(arrayIdx--);
			
			if (same_colour(tmp_node, tree_root)) {
				tmp_node.radius += distance_by_which_to_change;
			} else {
				tmp_node.radius -= distance_by_which_to_change;
			}
			
			//add next nodes to the stack
			//push the siblings first, so it tranverses to the
			//right first
			if (tmp_node.sibling != null) {
				backNodes.push(tmp_node.sibling);
			//	backNodes.add(tmp_node.sibling);
			//	arrayIdx++;
			}
			if (tmp_node.tight_away_from_tree_root != null) {
				backNodes.push(tmp_node.tight_away_from_tree_root);
			//	backNodes.add(tmp_node.tight_away_from_tree_root);
			//	arrayIdx++;
			}
		}
		
		/*
		// safety check
		if (the_node == null)
			return; // we are at the end of the tree, so do nothing

		// check the_node's colour and act appropriately
		if (same_colour(the_node, tree_root))
		{
			the_node.radius += distance_by_which_to_change;
			// set up for animation
			//support.output_grow(the_node.node_number);
		}
		else
		{
			the_node.radius -= distance_by_which_to_change;

			// set up for animation
			//support.output_shrink(the_node.node_number);
		}

		// recursively shrink or grow the nodes in the rest of the tree

		shrink_and_grow_the_tree(the_node.tight_away_from_tree_root);

		shrink_and_grow_the_tree(the_node.sibling);
		*/
	}

	// adds the_node_to_be_put to the last ("rightmost") sibling node linked to
	// "where"
	// 	-- used to add an item to a tree which has just bumped some node X in the
	// tree,
	// 	where X is already tight with some nodes -- i.e.
	// X.tight_away_from_tree_root
	// 	is non-null
	
	//fixed so its non-recursive!
	
	private void make_node_tight_with_a_further_node(MatchNode where,
			MatchNode the_node_to_be_put)
	{
		
		boolean made_tight = false;
		MatchNode thisNode = where;
		
		// safety check
		if (thisNode == null || the_node_to_be_put == null)
			return; // we were passed a null pointer, so do nothing

		while (!made_tight) {
				// check to see if this is the siblingmost node
				if (thisNode.sibling == null) {
					//	this node is the siblingmost node, so put the_node_to_be_put to
					// the sibling
					thisNode.sibling = the_node_to_be_put;
					made_tight = true;
				} else {
					// we are not at the siblingmost node, so continue looking for it
					// recursively
					thisNode = thisNode.sibling;
					//make_node_tight_with_a_further_node(where.sibling,
						//	the_node_to_be_put);
				}
		}
		
		/*
		if( where == null || the_node_to_be_put == null )
			return;		// we were passed a null pointer, so do nothing
		// check to see if this is the siblingmost node
		
		if( where.sibling == null )	{
			//	this node is the siblingmost node, so put the_node_to_be_put to the sibling
			where.sibling = the_node_to_be_put;
		} else {
			// we are not at the siblingmost node, so continue looking for it recursively
			make_node_tight_with_a_further_node( where.sibling, the_node_to_be_put );
		}
		*/
	}

	private void find_the_next_bump(MatchNode the_node)
	{
		
		//use a stack to keep track of nodes while traversing
		Stack backNodes = new Stack();
		//ArrayList backNodes = new ArrayList();
		//int arrayIdx = 0;
	
		MatchNode temp_node;
		float temp_distance;
		
		if (the_node == null) {
			return;
		}
		
		backNodes.push(the_node);
		//backNodes.add(the_node);
		
		while (!backNodes.empty()) {
		//while (!backNodes.isEmpty()) {
			MatchNode curr_node = (MatchNode)backNodes.pop();
			//MatchNode curr_node = (MatchNode)backNodes.remove(arrayIdx--);
			
			// we check only nodes the same colour as the tree root

			if (same_colour(curr_node, tree_root)) {
				for (temp_node = first_node; temp_node != null; temp_node = temp_node.next_node) {
					// we check the_node only against nodes of opposite colour which
					// aren't in the tree
					if (!same_colour(temp_node, curr_node) && temp_node.tight_towards_tree_root == null) {

						temp_distance = (temp_node.distance_to(curr_node))
								- (temp_node.radius + the_node.radius);

						if (temp_distance < distance_by_which_to_change) {
							distance_by_which_to_change = temp_distance;
							the_bumper = the_node;
							the_bumpee = temp_node;
						}
					}
				}
			}
			
			//add next nodes to the stack
			//push the siblings first, so it tranverses to the
			//right first
			if (curr_node.sibling != null) {
				backNodes.push(curr_node.sibling);
			//	backNodes.add(curr_node.sibling);
			//	arrayIdx++;
			}
			if (curr_node.tight_away_from_tree_root != null) {
				backNodes.push(curr_node.tight_away_from_tree_root);
			//	backNodes.add(curr_node.tight_away_from_tree_root);
			//	arrayIdx++;
			}

		}
		
		
		/*
		MatchNode temp_node;

		float temp_distance;

		// safety check

		if (the_node == null)
			return;

		// we check only nodes the same colour as the tree root

		if (same_colour(the_node, tree_root))
		{

			for (temp_node = first_node; temp_node != null; temp_node = temp_node.next_node)
			{

				// we check the_node only against nodes of opposite colour which
				// aren't in the tree

				if (!same_colour(temp_node, the_node)
						&& temp_node.tight_towards_tree_root == null)
				{

					//original
					//temp_distance = support.input_distance(
					//		temp_node.node_number, the_node.node_number)
					//		- (temp_node.radius + the_node.radius);
					
					//davidized!
					temp_distance = (temp_node.distance_to(the_node))
							- (temp_node.radius + the_node.radius);

					if (temp_distance < distance_by_which_to_change)
					{
						distance_by_which_to_change = temp_distance;

						the_bumper = the_node;

						the_bumpee = temp_node;

					}

				}

			}

		}

		// now recursively go down through the tree

		find_the_next_bump(the_node.tight_away_from_tree_root);

		find_the_next_bump(the_node.sibling);
		*/
		
	}

	private void augment()
	{

		// safety check
		if (current_augment_node == null)
			return;

		if (current_augment_node.tight_towards_tree_root == null)
			return;

		if (same_colour(current_augment_node, tree_root))
		{

			// set the animation up to make the marriage line disappear and the
			// tight line appear

			//support.output_divorce(current_augment_node.node_number,
				//	current_augment_node.tight_towards_tree_root.node_number);

			//support.output_add_tight_line(current_augment_node.node_number,
				//	current_augment_node.tight_towards_tree_root.node_number);

		}
		else
		{

			// change our data to reflect the marriage

			current_augment_node.spouse = current_augment_node.tight_towards_tree_root;

			current_augment_node.tight_towards_tree_root.spouse = current_augment_node;

			// set the animation up to make the marriage line appear and the
			// tight line disappear

			//support.output_marry(current_augment_node.node_number,
				//	current_augment_node.spouse.node_number);

			//support.output_remove_tight_line(current_augment_node.node_number,
				//	current_augment_node.spouse.node_number);

		}

		// now set things to augment next time starting one node further towards
		// the tree root

		current_augment_node = current_augment_node.tight_towards_tree_root;

	}

	
	private void reset_tree(MatchNode the_node)
	{
		// safety check
		if (the_node == null)
			return; // we were passed a null pointer, so do nothing

		// go further down the tree -- reset_tree will just come back out if the
		// pointer

		// 	is null, so no need to check

		if (the_node.tight_towards_tree_root != null)

			//support.output_remove_tight_line(the_node.node_number,
				//	the_node.tight_towards_tree_root.node_number);

		reset_tree(the_node.tight_away_from_tree_root);

		reset_tree(the_node.sibling);

		// now we should have reset all the nodes below this node, so reset this
		// node's pointers to null

		the_node.tight_away_from_tree_root = null;

		the_node.tight_towards_tree_root = null;

		the_node.sibling = null;

		// a special case

		if (the_node == tree_root)
		{
			//support.output_highlite_node(tree_root.node_number, false);
			tree_root = null;
		}

	}
	
	
	public void resetAlgorithm () {
		first_node = null;
		tree_root = null;
		the_bumper = null;
		the_bumpee = null;
		current_augment_node = null;
		augmenting_needs_doing = true;
	}
	
	/*
	private void add_node()
	// 	node numbering starts at 1
	{
		node temp_node, previous_node;
		
		short node_number_counter;

		// it matters what order nodes are stored, as the user may want to see
		// node numbers

		// 	so move to the first null handle in the linked list of nodes
		// belonging to the current graph

		node_number_counter = 1;

		temp_node = first_node;

		previous_node = first_node; //just to make Java happy

		while (temp_node != null)
		{
			node_number_counter++;

			previous_node = temp_node;

			temp_node = temp_node.next_node;
		}

		temp_node = new node();

		// take special action if the new node is the first node to be added to
		// the graph

		if (first_node == null)
			first_node = temp_node;
		else
			// the graph already has nodes, so make the node before the new node
			// point to that new node
			previous_node.next_node = temp_node;

		// initialize the new node

		temp_node.node_number = node_number_counter;

		//temp_node.radius = support.input_initial_disc_size(node_number_counter);
		temp_node.radius = 0.0f;
		
		temp_node.spouse = null;

		temp_node.tight_towards_tree_root = null;

		temp_node.tight_away_from_tree_root = null;

		temp_node.sibling = null;

		temp_node.next_node = null;

		temp_node.x = support.input_node_x(node_number_counter);
		temp_node.y = support.input_node_y(node_number_counter);
		temp_node.is_blue = support.input_is_node_blue(node_number_counter);
	}
	*/

	
	public float calc_distance () {
		float dist = 0.0f;
		
		MatchNode temp_node = null;

		// get the radius between married nodes
		for (temp_node = first_node; temp_node != null; temp_node = temp_node.next_node)
		{
			if ((temp_node.spouse != null) && (!temp_node.counted)) {
				temp_node.counted = true;
				temp_node.spouse.counted = true;
				dist += temp_node.radius;
				System.out.println("temp_node: " + temp_node.node_number +
						", temp_node.spouce: " + temp_node.spouse.node_number +
						"; distance: " + temp_node.radius);
			}
			if ((temp_node.spouse == null) && (!temp_node.counted)) {
				System.out.println("tmp_node.spouse == null. tmp_node.node_number: " + temp_node.node_number);
				temp_node.counted = true;
				dist += temp_node.x;
			} 
		}
		
		System.out.println("Total Distance: " + dist);
		
		return dist;
	}
}

