/*
 * Created on November 1, 2004
 *
 * This is a simple implementation of a cartesian distance calculation involving all the objects in the scene
 * (lines, flags, players, goal, ball)
 * 
 * This version uses vision-cell discretization in the calculation.
 * 
 */
package visiontable;

import java.util.*;

/**
 * @author kevlam
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class NearestNeighborCartesianCellObjects extends NearestNeighborParent
{
	private float penalty = 100;
	
	char friendlyside ='l';
	char enemyside = 'r';

	/**
	 * @param k
	 */
	public NearestNeighborCartesianCellObjects(int k, char side)
	{
		super(k, side);
		if (side == 'r') {
			friendlyside = 'r';
			enemyside= 'l';
		}

	}

	/* (non-Javadoc)
	 * @see visiontable.DistanceCalculation#distanceBetween(visiontable.VisionTable, visiontable.VisionTable)
	 */
	public float distanceBetween(Scene one, Scene two)
	{
		float totalDist = 0;
		// get lists of each type of object, and run distance calculation for each
		// then take sum of all distances between sets of objects
		if (weightBalls > 0)
		{
			totalDist += getDistanceForObjectList(one.getBallObjects().toArray(), 
											  two.getBallObjects().toArray()) * weightBalls;
		}
		
		// break into opponents/teammates/unknowns?
		if (weightAllPlayers > 0)
		{
			totalDist += getDistanceForObjectList(one.getPlayerObjects().toArray(), 
											  two.getPlayerObjects().toArray()) * weightAllPlayers;
		}

		if (weightTeammates > 0)
		{
			totalDist += getDistanceForObjectList(one.getTeammateObjects().toArray(), 
											  two.getTeammateObjects().toArray()) * weightTeammates;
		}
		
		if (weightOpponents > 0)
		{
			totalDist += getDistanceForObjectList(one.getOpponentObjects().toArray(), 
											  two.getOpponentObjects().toArray()) * weightOpponents;
		}

		if (weightUnknownPlayers > 0)
		{		
			totalDist += getDistanceForObjectList(one.getUnknownPlayerObjects().toArray(), 
											  two.getUnknownPlayerObjects().toArray()) * weightUnknownPlayers;
		}
			
		// should differentiate opponent/team goals
		if (weightGoals > 0)
		{
			totalDist += getDistanceForObjectList(one.getGoalObjects().toArray(), 
											  two.getGoalObjects().toArray()) * weightGoals;
		}
		
		// not really valid unless we can logically correspond by line types (but we can't get too specific, either...)
		if (weightLines > 0)
		{
			totalDist += getDistanceForObjectList(one.getLineObjects().toArray(), 
											  two.getLineObjects().toArray()) * weightLines;
		}
		
		// not really valid unless we can logically correspond by flag types
		if (weightFlags > 0)
		{
			totalDist += getDistanceForObjectList(one.getFlagObjects().toArray(), 
											  two.getFlagObjects().toArray()) * weightFlags;
		}
		
		return totalDist;
	}
	
	// this is a heuristic algorithm that simply sorts from nearest to farthest in the two lists, then pairs off
	// other algorithms exist (bipartite matching etc)
	public float getDistanceForObjectList(Object[] objectsOne, Object[] objectsTwo)
	{
		int sceneOneSize = objectsOne.length;
		sortObjectsByDistance(objectsOne);
		
		int sceneTwoSize = objectsTwo.length;
		sortObjectsByDistance(objectsTwo);
		
		int smaller = (sceneOneSize < sceneTwoSize ? sceneOneSize :sceneTwoSize );
		int larger = (sceneOneSize > sceneTwoSize ? sceneOneSize :sceneTwoSize );
		
		float totalDist = 0;
		
		for (int i = 0; i < smaller; i++)
		{
			int x1 = ((ObjectInfo) objectsOne[i]).getTableColumn();
			int y1 = ((ObjectInfo) objectsOne[i]).getTableRow();
			int x2 = ((ObjectInfo) objectsTwo[i]).getTableColumn();
			int y2 = ((ObjectInfo) objectsTwo[i]).getTableRow();
			
			totalDist += cartesianDistance(x1, y1, x2, y2);
		}
		// assess penalty for all objects in one list but not in another?
		totalDist += (larger - smaller) * penalty;
		
		return totalDist;
	}

	// sorts the array by the distance from discrete cell point (0,0)
	// note that the sort order may CHANGE if you sort from a different cell point
	public void sortObjectsByDistance(Object [] sceneObjects)
	{
		Arrays.sort(sceneObjects, new Comparator()
			{
				 public int compare(Object o1, Object o2)
				 {
					 int x1 = ((ObjectInfo) o1).getTableColumn();
					 int y1 = ((ObjectInfo) o1).getTableRow();
					 int x2 = ((ObjectInfo) o2).getTableColumn();
					 int y2 = ((ObjectInfo) o2).getTableRow();
					
					 float dist1 = cartesianDistance(0, 0, x1, y1);
					 float dist2 = cartesianDistance(0, 0, x2, y2);
					 
					 if (dist1 == dist2)
						return 0;
					 else
						return (dist1 > dist2 ? 1 : -1);
				 }
			});
		
	}

}
