/*
 * Created on Aug 18, 2004
 *
 * This is a nearest-neighbor distance-calculation algorithm that uses the discretization in cells
 * 
 * we're interested only in the ball right now; figure out which coordinates contain it in each table, return the result in terms of
 * distance between those coordinates
 * 
 * i.e. (0,0) and (0,0) --> distance 0, exact match
 *      (0,1) and (0,2) --> distance 1.0
 * 
 * and so on. 
 * 
 */
package visiontable;

/**
 * @author Kevin Lam
 *
 */
public class NearestNeighborCellBallDistance extends NearestNeighborParent
{
	int kValue = 1;
	
	/**
	 * 
	 */
	public NearestNeighborCellBallDistance(int k, char side)
	{
		super(k, side);
	}

	/* (non-Javadoc)
	 * @see visiontable.DistanceCalculation#distanceBetween(visiontable.VisionTable, visiontable.VisionTable)
	 */
	public float distanceBetween(Scene one, Scene two)
	{
		int x1 = 999, y1 = 999, x2 = 999, y2 = 999;
		
		// step 1: find coordinates of ball in each VisionTable
		if (one.getBallObjects().size() > 0)
		{
			ObjectInfo ballOne = (ObjectInfo) one.getBallObjects().elementAt(0);
			
			x1 = ballOne.getTableColumn();
			y1 = ballOne.getTableRow();
		}
		if (two.getBallObjects().size() > 0)
		{
			ObjectInfo ballTwo = (ObjectInfo) two.getBallObjects().elementAt(0);
			
			x2 = ballTwo.getTableColumn();
			y2 = ballTwo.getTableRow();
		}
		
		return cartesianDistance(x1, y1, x2, y2);
	}

}
