package visiontable;

import java.io.Serializable;

//
//	File:			ObjectInfo.java
//	Author:		Krzysztof Langner
//	Date:			1997/04/28

//  Modified by:  Paul Marlow, Amir Ghavam, Yoga Selvaraj
//  Course:       Software Agents
//  Date Due:     November 30, 2000

//  Modified again by Kevin Lam
//                 October 19, 2004
//                 added SceneTable col/row attributes

//***************************************************************************
//
//	This is base class for different classese with visual information
//	about objects
//
//***************************************************************************
public class ObjectInfo implements Serializable
{
  public String m_type;
  public float m_distance;
  public float m_direction;
  public float m_distChange;
  public float m_dirChange;

  public int m_tableRow;
  public int m_tableCol;


  //===========================================================================
  // Initialization member functions
  public ObjectInfo(String type)
  {
    m_type = type;
  }

  public float getDistance()
  {
    return m_distance;
  }

  public float getDirection()
  {
    return m_direction;
  }

  public float getDistChange()
  {
    return m_distChange;
  }

  public float getDirChange()
  {
    return m_dirChange;
  }

  public String getType()
  {
    return m_type;
  }
/**
 * @return
 */
public int getTableColumn()
{
	return m_tableCol;
}

/**
 * @return
 */
public int getTableRow()
{
	return m_tableRow;
}

/**
 * @param i
 */
public void setTableColumn(int i)
{
	m_tableCol = i;
}

/**
 * @param i
 */
public void setTableRow(int i)
{
	m_tableRow = i;
}

/**
 * Hack because original code is package private.
 */
public String getTeamNameHack()
{
    if (this instanceof PlayerInfo)
        return ((PlayerInfo) this).getTeamName();
    return "";
}

}

