/*
 * Created on Aug 18, 2004
 *
 * Implementation history
 *    August 2004:    ChooseFirstValid
 *    August 2004:    ChooseKickPriority
 *    October 5 2004: VoteEqualWeighted
 *    January 25 2005: rewrite to support only ChooseFirstValid, ChooseRandom, and VoteWeighted
 *    January 26 2005: added a combination VoteWeightedWithRandom algorithm
 * 
 */
package visiontable;

import java.util.*;

/**
 * @author Kevin Lam
 *
 * This class contains a set of algorithms for choosing one action based on a set of candidates
 * Various strategies may be implemented
 */
public class SceneSelection
{

	/**
	 * 
	 */
	public SceneSelection()
	{
		super();
	}

	/**
	 * @param bestScenes
	 * @return
	 */
	public static Scene ChooseFirstValid(Scene[] bestScenes)
	{
		Vector actions = null;
		for (int i = 0; i < bestScenes.length; i++)
		{
		   try {
			actions = bestScenes[i].getActions();
			if (actions != null)
				return bestScenes[i];
		   } catch(NullPointerException e) {
			// do nothing
		   }
		}
		return bestScenes[0];	
	}

	/**
	 * @param bestScenes
	 * @return
	 */
	public static Scene ChooseRandom(Scene[] bestScenes, int num)
	{
		Vector actions = null;

		Random generator = new Random();
		
		int i = generator.nextInt( bestScenes.length );
		
		   try {
			actions = bestScenes[i].getActions();
			if (actions != null)
				return bestScenes[i];
		   } catch(NullPointerException e) {
			// do nothing
		   }
		return ChooseFirstValid(bestScenes);	
	}

	/**
	 * don't use me, I'm deprecated
	 * @param bestScenes
	 * @return
	 */
	private static Scene ChooseKickPriority(Scene[] bestScenes, int kValue)
	{
		return ChooseActionPriority(bestScenes, kValue, Action.ACTION_KICK);	
	}

	/**
	 * don't use me, I'm deprecated
	 * @param bestScenes
	 * @return
	 */
	private static Scene ChooseActionPriority(Scene[] bestScenes, int kValue, int chosenAction)
	{
		// is there the selected action?
//		for (int i = 0; i < kValue; i++)
		for (int i = 0; i < bestScenes.length; i++)
		{
		    try {
			Vector actions = bestScenes[i].getActions();
			if (actions != null) 
			{
				for(int j = 0; j < actions.size(); j++)
				{
					Action a = (Action) actions.get(j);
					if (a.getAction() == chosenAction)
						return bestScenes[i];
				}
			}
		    } catch(NullPointerException e) {
		        // do nothing
		    }
		}

		// else return first useful action				
		return ChooseFirstValid(bestScenes);	
	}


	/**
	 * don't use me, I'm deprecated
	 * @param bestScenes
	 * @return
	 */
	private static Scene VoteEqualWeighted(Scene[] bestScenes, int kValue)
	{
		float weightList[] = new float[7];
		for (int i = 0; i < 7; i++) 
			weightList[i] = 1;		// equal weighting for all
			
		return VoteWeighted(bestScenes, kValue, weightList);
	}	

	/**
	 * @param bestScenes
	 * @return
	 */
	public static Scene VoteWeighted(Scene[] bestScenes, int kValue, float[] weightList)
	{

		// take a simple vote between them all
		float actionList[] = new float[7];
		for (int i = 0; i < 7; i++) 
			actionList[i] = 0;
		
// This assumes all kValue bestScenes are filled, which is not always true.
//		for (int i = 0; i < kValue; i++)
		for (int i = 0; i < bestScenes.length; i++)
		{
		    try {
			Vector actions = bestScenes[i].getActions();
			if (actions.size() > 0)
			{
				for(int j = 0; j < actions.size(); j++)
				{
					Action a = (Action) actions.get(j);
					actionList[a.getAction()]++;
					
				} // end for (all actions in this scene)
			} // end if (actions exist)
		    } catch(NullPointerException e) {
		        // do nothing
		    }
		} // end for (all scenes)
		
		// now process weightings
		for (int i = 0; i < 7; i++) 
			actionList[i] = actionList[i] * weightList[i];
		
		// now pick the most popular!  -- ranking can happen here too... ?
		
		//System.out.println("Vote results:");
		int chooseVote = 0;
		double currentBest = 0;
		for(int i = 0; i < 7; i++)
		{
			if (actionList[i] > currentBest)
			{
				currentBest = actionList[i];
				chooseVote = i;
			}
			//System.out.println("Action " + Action.actions[i] + ": " + actionList[i]);
		}
		//System.out.println("Decision is: " + Action.actions[chooseVote]);
		
		// do it!
		return ChooseActionPriority(bestScenes, kValue, chooseVote);	
	}

	/**
	 * Pick a weighted vote but x% of the time just do something random
	 * @param bestScenes
	 * @return
	 */
	public static Scene VoteWeightedWithRandom(Scene[] bestScenes, int kValue, float[] weightList, int randChance)
	{
		Random generator = new Random();
		
		if (generator.nextInt(100) > randChance)
		{
			return VoteWeighted(bestScenes, kValue, weightList);	
		}
		else
		{
			return ChooseRandom(bestScenes, kValue);
		}
	}


}