package visiontable;
import java.io.*;
import java.util.*;

// written so we could reverse-engineer the Scene objects files written with earlier versions of the Scene code
// to get around Java serialization versioning issues

public class SceneToLogs
{
	int numRows = 3;
	int numCols = 5;
	
	Vector scenes = new Vector();
	
	public static void main(String[] args)
	{

		int linecount = 0;
		int numRows = 3;
		int numCols = 5;
        String my_team;
		
		StringTokenizer m_tokenizer;
		SceneToLogs lp = new SceneToLogs();
		
		// look for parameters
		if (args.length < 2)
		{
			System.err.println(
				"SceneToLogs - generates logs from Scenes");
			System.err.println("\nUsage: java SceneToLogs in-file.scene out-file.log");
			return;
		}
				
		// load scenes from file
		lp.loadSceneFile(args[0]);
		
		// write file back out to logs
		lp.dumpLogs(args[1]);

	}
	
	public void loadSceneFile(String fname)
		{
			System.out.println("Loading scenes from file " + fname);
			try
			{
				FileInputStream fileIn = new FileInputStream(fname);
				
				ObjectInputStream ois = new ObjectInputStream(fileIn);
				numRows = ((Integer) ois.readObject()).intValue();
				numCols = ((Integer) ois.readObject()).intValue();
				scenes = (Vector) ois.readObject();
				  
				ois.close();
				fileIn.close();
			}
			catch (FileNotFoundException e)
			{
				e.printStackTrace();
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
			catch (ClassNotFoundException e)
			{
				e.printStackTrace();
			}
		
			System.out.println("Read " + scenes.size() + " scenes, table size (" + numRows + "," + numCols + ")");
		
		}

	void dumpLogs(String fname)
	{
		try
		{
			FileOutputStream fileOut = new FileOutputStream(fname);
			OutputStreamWriter outWriter =
				new OutputStreamWriter(fileOut, "US-ASCII");
			// throws exception
			PrintWriter out = new PrintWriter(outWriter); // throws exception
			
			System.out.println("Writing log file to " + fname);

			// iterate through objects here
			Iterator it = scenes.iterator();
			while (it.hasNext())
			{
				Scene thisScene = (Scene) it.next();
				if ((thisScene!=null)&&(thisScene.getVision() != null) )
					out.println(thisScene.getVision().m_message);

				Iterator actionIt = thisScene.getActions().iterator();
				while(actionIt.hasNext()) {
				  Action action = (Action) actionIt.next();
				  switch(action.getAction())
				  {
					case Action.ACTION_NONE:
					{
						break;
					}
					case Action.ACTION_KICK:
					{
						out.println("(kick " + Double.toString(action.getActionPower()) + " " + Double.toString(action.getActionDirection()) + ")");
						break;
					}
					case Action.ACTION_TURN:
					{
						out.println("(turn " + Double.toString(action.getActionDirection()) + ")");
						break;
					}
					case Action.ACTION_MOVE:
					{
						out.println("(move " + Double.toString(action.getActionX()) + " " + Double.toString(action.getActionY()) + ")");
						break;
					}
					case Action.ACTION_TURNNECK:
					{
						out.println("(turn_neck " + Double.toString(action.getActionDirection()) + ")");
						break;
					}
					case Action.ACTION_DASH:
					{
						out.println("(dash " + Double.toString(action.getActionPower()) + ")");
						break;
					}
					case Action.ACTION_CATCH:
					{
						break;
					}
				  	default:
				  	{
				  		break;
				  	}
				  } // end switch

				} // end while (actions)
			} // end while (scenes)	

			// end of human-readable format...
			out.close();
			outWriter.close(); // throws exception
			fileOut.close();
			
		}
		catch (FileNotFoundException e)
		{

			e.printStackTrace();
		}
		catch (UnsupportedEncodingException e)
		{

			e.printStackTrace();
		}
		catch (IOException e)
		{

			e.printStackTrace();
		}
		
		System.out.println("Wrote " + scenes.size() + " scenes.");
		
	}

}